<?php
/*
Addon Name: Flow Builder
Unique Name: flow_builder
Modules:
{
   "777":{
      "bulk_limit_enabled":"0",
      "limit_enabled":"1",
      "extra_text":"",
      "module_name":"Flow Builder - Limit On Number Of Flows User Can Create"
   },
   "778":{
      "bulk_limit_enabled":"0",
      "limit_enabled":"0",
      "extra_text":"",
      "module_name":"Flow Builder - Allow Subscribers To Use Templates"
   }
}

Project ID: 77
Addon URI: https://colzzky.com
Author: Colzzky
Author URI: http://colzzky.net
Version: 1.91
Description:
*/

require_once("application/controllers/Home.php");

class Flow_builder extends Home
{
    
    public $version = 1.91;
    
	public function __construct(){
	    parent::__construct();
		$function_name=$this->uri->segment(2);
		if($function_name!="webview" && $function_name!="form_submit") 
		{
			if ($this->session->userdata('logged_in')!= 1) redirect('home/login', 'location');
		}

		// getting addon information in array and storing to public variable
		// addon_name,unique_name,module_id,addon_uri,author,author_uri,version,description,controller_name,installed
		//------------------------------------------------------------------------------------------
		$addon_path=APPPATH."modules/".strtolower($this->router->fetch_class())."/controllers/".ucfirst($this->router->fetch_class()).".php"; // path of addon controller
		$addondata=$this->get_addon_data($addon_path);
		$this->member_validity();
		$this->addon_data=$addondata;
        $this->user_id=$this->session->userdata('user_id');
        
        ini_set('post_max_size', '250M');
        
        if($this->session->userdata('user_type') == 'Admin'){
            $this->update_addon_data_to_db();    
        }
        
        if( $this->version < 1.7){
            $this->init_db_template();
            $this->register_addon_manager();
        }
        
        $this->lang->load("flow_builder",$this->language,FALSE,TRUE,"application/modules/flow_builder/language/".$this->language);
        
	}
	
	public function documentation(){
	    $this->load->view('documentation', array());
	}
	
	public function index(){
        if($this->session->userdata('user_type') != 'Admin' && !in_array(777,$this->module_access)){
        	$data['body'] = 'access_denied';
        	$data['page_title'] = $this->lang->line("Access Denied");
        	$data['message'] = $this->lang->line("You do not have permission to access this content. Upgrade Your Account To Do More.");
            $this->_viewcontroller($data);
            return;
        }	    
		$this->show_Flow_builder();
	}
	
	public function show_Flow_builder(){	
    	$data['page_info'] = array();
    	$data['body'] = 'dashboard';
    	$data['page_title'] = "Flow Builder";
    	$data['user_id'] = $this->user_id;
    	$data['user_email'] = $this->session->userdata("user_login_email");
    	$data['user_type'] = $this->session->userdata('user_type');
    	$data['need_update'] = $this->need_update();
    	$data['site_url'] = site_url();
    	$data['template_data'] = $this->ext_get_user_templates();
    	$this->_viewcontroller($data);
	}

	public function flow(){
        if($this->session->userdata('user_type') != 'Admin' && !in_array(777,$this->module_access)){
        	$data['body'] = 'access_denied';
        	$data['page_title'] = $this->lang->line("Access Denied");  
        	$data['message'] = $this->lang->line("You do not have permission to access this content. Upgrade Your Account To Do More.");
            $this->_viewcontroller($data);
            return;
        }
    	$data['page_info'] = array();
    	$data['body'] = 'build';
    	$data['page_title'] = "Flow Builder";
    	$data['user_id'] = $this->user_id;
    	$data['user_email'] = $this->session->userdata("user_login_email");
    	$data['user_type'] = $this->session->userdata('user_type');
    	$data['need_update'] = $this->need_update();
    	$data['site_url'] = site_url();
    	$data['flow_builder_script'] = $this->get_flow_builder_script();
    	$data['efb_exists'] = $this->ext_check_if_email_flow_builder_exists();
    	$this->_viewcontroller($data);
	}
	
	public function ext_save_new_flow_data(){

        $is_new = true;
        $this->ajax_check();
        $flow_data  =   $this->input->post('flow_data');
        $fb_page_id =   $this->input->post('page_id');
        $result     =   $this->input->post('data');
        $user_id    =   $this->input->post('user_id');
        $post_id    =   $this->input->post('post_id');
        $flowName   =   $this->input->post('flow_name');
        
        $sql = "SELECT email FROM `users` where id=$user_id;";
        $r = $this->db->query($sql)->row_array();
        $owner = $r['email'];        
        
        //Reset Redis Cache
        /*$key1 = 'webhook_callback_main_message_payload_'.$fb_page_id;
        $key2 = 'webhook_callback_main_message_for_all_'.$fb_page_id;
        $key3 = 'template_jsoncode_'.$owner;
        $this->ext_init_redis();
        $this->ext_delete_option($key1);
        $this->ext_delete_option($key2);
        $this->ext_delete_option($key3);*/
    
        $page_data = $this->ext_get_user_page_row_id($user_id,$fb_page_id);
        $page_data = $page_data[0];
        
        $page_id = $page_data['id'];
        $page_name = $page_data['page_name'];
        $access_token = $page_data['page_access_token'];

        $is_new = true;
        $output = array();
        $output['post_id'] = array();
        $output['post_id']['id'] = ($post_id)?$post_id:"";
        $output['post_id']['result'] = array();

        foreach($result as $k=>$data){
            
            $_message = json_encode($data['data'], true);
            $message = urldecode($_message);
            
            $bot_name = $data['name'];
            $postback_id = $data['postbackid'];
            
            if(array_key_exists('labels',$data)){
                $labels = $data['labels'];
            }else{
                $labels = "";
            }
            
            if(array_key_exists('triggers',$data)){
                $triggers = $data['triggers'];
            }else{
                $triggers = "";
            }
            
            if(array_key_exists('user_input',$data)){
                $user_input = $data['user_input'];
            }else{
                $user_input = "";
            }            
    
            try{
                if(array_key_exists("trigger_messenger",$data)){
                    $sequence_postback_id = $data['trigger_messenger'];
                    $webhook_name = "FlowBuilder_MessengerSequence_".$sequence_postback_id;
                    $sequence_post_url = $data['sequence_post_url'];
                    $output['post_id']['result'][] = $this->ext_insert_db_webhook_sequence_data($webhook_name, $user_id, $fb_page_id, $page_name, $sequence_post_url, $owner, 'trigger_messenger', $sequence_postback_id);
                }
                
                if(array_key_exists("trigger_email",$data)){
                    $sequence_postback_id = "";
                    $webhook_name = "FlowBuilder_EmailSequence_".$data['trigger_email'];
                    $sequence_post_url = $data['sequence_post_url'];            
                    $output['post_id']['result'][] = $this->ext_insert_db_webhook_sequence_data($webhook_name, $user_id, $fb_page_id, $page_name, $sequence_post_url, $owner, 'trigger_email', $sequence_postback_id);
                }
                
                if(array_key_exists("trigger_phone_number",$data)){
                    $sequence_postback_id = "";
                    $webhook_name = "FlowBuilder_SMSSequence_".$data['trigger_phone_number'];
                    $sequence_post_url = $data['sequence_post_url'];           
                    $output['post_id']['result'][] = $this->ext_insert_db_webhook_sequence_data($webhook_name, $user_id, $fb_page_id, $page_name, $sequence_post_url, $owner, 'trigger_phone_number', $sequence_postback_id);
                }
                
                if(array_key_exists("action",$data)){
                    if($data["action"] == "new"){
                        $otn_name = $data["otn_name"];
                        $callback_postback_id = $data["callback_postbackid"];
                        $otn_payload = $this->ext_create_new_otn_template($otn_name, $callback_postback_id, $page_id, $user_id, $labels);
                        if($otn_payload){
                            $message = str_replace('{REPLACE_ME_OTN_PAYLOAD}', $otn_payload, $message);    
                        }
                    }
                }
                
            }catch( Exception $e ){
                $output['post_id']['result'][] = $e->getMessage();
            }
            
            $sql1 = " SELECT id,messenger_bot_table_id FROM `messenger_bot_postback` where postback_id='$postback_id' ";
            $is_exists1 = $this->db->query($sql1)->row_array();
            
            $sql2 = " SELECT id FROM `messenger_bot` where postback_id='$postback_id' ";
            $is_exists2 = $this->db->query($sql2)->row_array();
            if($is_exists1 || $is_exists2){
                $messenger_bot = isset($is_exists1['messenger_bot_table_id'])?$is_exists1['messenger_bot_table_id']:$is_exists2["id"];
                $messenger_bot_postback = isset($is_exists1['id'])?$is_exists1['id']:"";
                $output['post_id']['result'][] = $this->ext_update_db_flow_data($user_id,$fb_page_id,$message,$bot_name,$messenger_bot,$messenger_bot_postback,$labels,$triggers,$postback_id, $page_id, $user_input);
                $is_new = false;
            }else{
                $output['post_id']['result'][] = $this->ext_insert_db_flow_data($user_id,$page_id,$fb_page_id,$message,$bot_name,$postback_id,$labels,$triggers, $user_input);
            }
            
        }
        
        if($post_id){
            $template_id = $this->db->query(" SELECT template_id FROM `ext_flow_builder` WHERE id='$post_id'; ")->row_array();
            if($template_id['template_id'] != ""){
                $this->ext_update_template($flow_data, $template_id['template_id'], $flowName);
            }
        }
        
        if($is_new){
            $post_id = $this->ext_create_new_flow($user_id, $page_id, $page_name, $fb_page_id, $flowName, json_encode($result), $flow_data );
            $output['post_id']['id'] = $post_id;
        }else{
            if($post_id){
                $this->ext_update_flow($flowName, json_encode($result), $flow_data, $post_id);   
                $output['post_id']['id'] = $post_id;
            }
        }
        
        echo json_encode($output);
        
        return;
    
    }
    
    public function ext_create_new_flow($user_id, $page_id, $page_name, $fb_page_id, $name, $json_template, $flow_data ){
        
        try{
            
            $row_arrays = array(
                'user_id' => $user_id,
                'page_id' => $page_id,
                'page_name' => $page_name,
                'fb_page_id' => $fb_page_id,
                'name' => $name,
                'json_template' => $json_template,
                'flow_data' => $flow_data,
            );
            
            $this->db->insert('ext_flow_builder', $row_arrays);
            $post_id = $this->db->insert_id();
            if($post_id){
                $this->_insert_usage_log(777,1,$user_id);
            }
            return $post_id;
            
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }        

    }
    
    public function ext_update_flow($name, $json_template, $flow_data,$post_id){
        
        try{
            
            $row_arrays = array(
                'name' => $name,
                'json_template' => $json_template,
                'flow_data' => $flow_data,
            );
            
            $where = array('id'=>$post_id);
            $this->basic->update_data('ext_flow_builder',$where,$row_arrays);
            
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }        

    }
    
	public function ext_get_flow_data_php(){
	    
        $this->ajax_check();
        $post_id  =   $this->input->post('post_id');
        
        $flow_data = $this->db->query(" SELECT flow_data FROM `ext_flow_builder` WHERE `id` = $post_id ")->row_array();
        echo $flow_data['flow_data'];
     
    }
    
	public function ext_insert_db_flow_data($user_id,$page_id,$fb_page_id,$message,$bot_name,$postback_id,$labels="",$triggers="", $user_input = ""){
	    
        $errors = $get_started = $comment_reply_saved = array();
        $keywords = $messenger_bot_postback = $messenger_bot_table_id = "";
        $errors[] = array($user_id,$page_id,$fb_page_id,$message,$bot_name,$postback_id,$labels,$triggers);
        
        try{
            if($triggers != ""){
                foreach($triggers as $trigger){
                    $type = $trigger['type'];
                    switch($type){
                        case "keyword";
                            $keywords .= $trigger['keyword'];
                        break;
                        case "get_started";
                            try{
                                $getStartedData = array(                        
                                    "message" => $message
                                );
                                $GSwhere = array('fb_page_id'=>$fb_page_id,'user_id'=>$user_id,'keyword_type'=>'get-started');
                                $get_started[] = $this->basic->update_data('messenger_bot',$GSwhere,$getStartedData);            
                            }catch(Exception $e){
                                $errors[] = $e->getMessage();
                            }
                        break;
                    }
                }        
            }
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }
    
        try{
            
            $row_arrays = array(
                'user_id' => $user_id,
                'page_id' => $page_id,
                'fb_page_id' => $fb_page_id,
                'template_type' => "text",
                'bot_type' => "generic",
                'keyword_type' => "reply",
                'keywords' => $keywords,
                'message' => $message,
                'buttons' => "",
                'images' => "",
                'audio' => "",
                'video' => "",
                'file' => "",
                'status' => '1',
                'bot_name' => $bot_name,
                'postback_id' => $postback_id,
                'last_replied_at' => "0000-00-00 00:00:00",
                'is_template' => "1",
                'broadcaster_labels' => $labels,
                'drip_campaign_id' => 0
            );
            
            $this->db->insert('messenger_bot', $row_arrays);
            $messenger_bot_table_id = $this->db->insert_id();
            
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }
        
        try{
            $message = $this->db->escape($message);
            $bot_name = $this->db->escape($bot_name);
            $sql = "INSERT INTO messenger_bot_postback (user_id, postback_id, page_id, use_status, status ,messenger_bot_table_id, bot_name, is_template, template_jsoncode, template_name, template_for, template_id, inherit_from_template, broadcaster_labels, drip_campaign_id) VALUES ";
            $sql .= " ($user_id, '$postback_id', '$page_id', '1', '1', $messenger_bot_table_id, \"$bot_name\", '1', $message, \"$bot_name\", 'reply_message', 0, 0, '$labels', 0 ) ";
            $sql .= " ON DUPLICATE KEY UPDATE template_jsoncode = VALUES(template_jsoncode), bot_name = VALUES(bot_name),  template_name = VALUES(template_name) ";
            $this->db->query($sql);
            $messenger_bot_postback = $this->db->insert_id();
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }
    
        try{
            if($triggers != ""){
                foreach($triggers as $trigger){
                    $type = $trigger['type'];
                    switch($type){
                        case "comment_reply";
                            $arr = explode("_",$trigger['value']);
                            $comment_reply_id = $arr[1];
                            $auto_reply_text_raw = $this->db->query(" SELECT auto_reply_text,reply_type FROM `facebook_ex_autoreply` WHERE `facebook_ex_autoreply`.`id` = $comment_reply_id ")->row_array();
                            $comment_reply_type = $auto_reply_text_raw['reply_type'];
                            $auto_reply_text = json_decode($auto_reply_text_raw['auto_reply_text'], false);
                            if($comment_reply_type == "filter"){
                                $comment_reply_text = $trigger['comment_message'];
                                $filter_keyword = $trigger['keyword'];
                                $mydata = json_decode('{"filter_word":"'.$filter_keyword.'","reply_text":"'.$messenger_bot_postback.'","comment_reply_text":"'.$comment_reply_text.'","image_link":"","video_link":""}',false);
                                array_push($auto_reply_text,$mydata);
                            }
                            if($comment_reply_type == "generic"){
                                $auto_reply_text[0]->private_reply = $messenger_bot_postback;
                            }
                            $auto_reply_text_final = json_encode($auto_reply_text);
                            try{
                                $CMreply = array(
                                    "auto_reply_text" => $auto_reply_text_final,
                                );
                                $CMWhere = array('id'=>$comment_reply_id);
                                $comment_reply_saved[$comment_reply_id] = $this->basic->update_data('facebook_ex_autoreply',$CMWhere,$CMreply);            
                            }catch(Exception $e){
                                $errors[] = $e->getMessage();
                            }
                        break;
                    }
                }
            }
        }catch( Exception $e){
            $errors[] = $e->getMessage();
        }
        
        $errors[] = array($messenger_bot_postback,$messenger_bot_table_id);
        if($messenger_bot_postback && $messenger_bot_table_id){
            return array( "status"=>1,"notice"=>"Success Saving $bot_name PostBack!", "messenger_bot_table_id"=>$messenger_bot_table_id,"messenger_bot_postback"=>$messenger_bot_postback, "comment_reply"=>$comment_reply_saved, "get_started"=>$get_started, "errors"=>$errors);    
        }else{
            return array( "status"=>0,"notice"=>"Error Saving $bot_name PostBack!", "messenger_bot_table_id"=>$messenger_bot_table_id,"messenger_bot_postback"=>$messenger_bot_postback, "comment_reply"=>$comment_reply_saved, "get_started"=>$get_started, "errors"=>$errors);
        }
        
    }
    
	public function ext_update_db_flow_data($user_id, $fb_page_id, $message,$bot_name,$messenger_bot,$messenger_bot_postback,$labels,$triggers="", $postback_id, $page_id, $user_input = ""){
        
        $errors = $get_started = $comment_reply_saved = array();
        $keywords = "";
        
        try{
            if($triggers != ""){
                foreach($triggers as $trigger){
                    $type = $trigger['type'];
                    switch($type){
                        case "keyword";
                            $keywords .= $trigger['keyword'];
                        break;
                        case "get_started";
                            try{
                                $getStartedData = array(                        
                                    "message" => $message
                                );
                                $GSwhere = array('fb_page_id'=>$fb_page_id,'user_id'=>$user_id,'keyword_type'=>'get-started');
                                $get_started[] = $this->basic->update_data('messenger_bot',$GSwhere,$getStartedData);            
                            }catch(Exception $e){
                                $errors[] = $e->getMessage();
                            }
                        break;        
                    }
                }        
            }        
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }    
        
        try{
            $Table1Data = array(
                'keywords' => $keywords,
                'message' => $message,
                'bot_name' => $bot_name,
                "broadcaster_labels" => $labels,
                'status' => '1',
            );

            $where = array('id'=>$messenger_bot);
            $a = $this->basic->update_data('messenger_bot',$where,$Table1Data);
            
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }
        
        try{
            
            if($messenger_bot_postback){
                $Table2Data = array(                        
                    "template_jsoncode" => $message,
                    "bot_name" => $bot_name,        
                    "template_name" => $bot_name,
                    "broadcaster_labels" => $labels,
                    'status' => '1',
                );
                $where = array('id'=>$messenger_bot_postback);
                $b = $this->basic->update_data('messenger_bot_postback',$where,$Table2Data);
            }else{
                try{
                    $message= $this->db->escape($message);
                    $bot_name = $this->db->escape($bot_name);
                    $sql = "INSERT INTO messenger_bot_postback (user_id, postback_id, page_id, use_status, status ,messenger_bot_table_id, bot_name, is_template, template_jsoncode, template_name, template_for, template_id, inherit_from_template, broadcaster_labels, drip_campaign_id) VALUES ";
                    $sql .= " ($user_id, '$postback_id', '$page_id', '1', '1', $messenger_bot, \"$bot_name\",'1', $message, \"$bot_name\", 'reply_message', 0, 0, '$labels', 0 ) ";
                    $sql .= " ON DUPLICATE KEY UPDATE template_jsoncode = VALUES(template_jsoncode), bot_name = VALUES(bot_name),  template_name = VALUES(template_name) ";
                    $this->db->query($sql);
                    $messenger_bot_postback = $this->db->insert_id();
                    if($messenger_bot_postback){
                        $b = true;
                    }
                }catch(Exception $e){
                    $errors[] = $e->getMessage();
                }                
            }
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }    
        
        try{
            if($triggers != ""){
                foreach($triggers as $trigger){
                    $type = $trigger['type'];
                    switch($type){
                        case "comment_reply";
                            $arr = explode("_",$trigger['value']);
                            $comment_reply_id = $arr[1];
                            $auto_reply_text_raw = $this->db->query(" SELECT auto_reply_text,reply_type FROM `facebook_ex_autoreply` WHERE `facebook_ex_autoreply`.`id` = $comment_reply_id ")->row_array();
                            $comment_reply_type = $auto_reply_text_raw['reply_type'];
                            $auto_reply_text = json_decode($auto_reply_text_raw['auto_reply_text'], false);
                            if($comment_reply_type == "filter"){
                                $reply_type = 'filter';
                                $comment_reply_text = $trigger['comment_message'];
                                $filter_keyword = $trigger['keyword'];
                                $mydata = json_decode('{"filter_word":"'.$filter_keyword.'","reply_text":"'.$messenger_bot_postback.'","comment_reply_text":"'.$comment_reply_text.'","image_link":"","video_link":""}',false);
                                array_push($auto_reply_text,$mydata);
                            }
                            if($comment_reply_type == "generic"){
                                $reply_type = 'generic';
                                $auto_reply_text[0]->private_reply = $messenger_bot_postback;
                            }
                            $auto_reply_text_final = json_encode($auto_reply_text);
                            try{
                                $CMreply = array(                        
                                    "auto_reply_text" => $auto_reply_text_final,
                                    "reply_type" => $reply_type,
                                );
                                $CMWhere = array('id'=>$comment_reply_id);
                                $comment_reply_saved[$comment_reply_id] = $this->basic->update_data('facebook_ex_autoreply',$CMWhere,$CMreply);            
                            }catch(Exception $e){
                                $errors[] = $e->getMessage();
                            }                            
                        break;
                    }
                }
            }
        }catch( Exception $e){
            $errors[] = $e->getMessage();
        }    
        
        if($a && $b){
            return array( "status"=>1,"notice"=>"Success updating $bot_name PostBack!","data"=>array($messenger_bot,$messenger_bot_postback,$a,$b), "comment_reply"=>$comment_reply_saved, "get_started"=>$get_started, "errors"=>$errors);    
        }else{
            return array( "status"=>0,"notice"=>"Error updating $bot_name PostBack!","data"=>array($messenger_bot,$messenger_bot_postback,$a,$b), "comment_reply"=>$comment_reply_saved, "get_started"=>$get_started, "errors"=>$errors);
        }
    
    }
    
	public function ext_get_flow_helper($user_id){

        $table_type = 'ext_flow_builder';
        $where_type['where'] = array('user_id'=>$user_id);
        $userflows = $this->basic->get_data($table_type,$where_type);
        return $userflows;
        
    }
    
	public function ext_get_user_flows(){

        $this->ajax_check();
        $user_id  =   $this->input->post('user_id');
        
        $data = $this->ext_get_flow_helper($user_id);
        foreach($data as $k=>$a){
            $page_name = $a['page_name'];
            $page_id = $a['page_id'];
            $data[$k]['page_name'] = $page_name;
            $data[$k]['page_id'] = $page_id;
        }
        
        echo json_encode($data);
        return false;
        
    }
    
	public function ext_get_user_pages_flow_builder(){

        $this->ajax_check();
        $user_id  =   $this->input->post('user_id');
        
        echo json_encode($this->ext_get_user_pages($user_id));
        
    }
    
	public function ext_get_user_subs(){

        $this->ajax_check();
        $result  =   $this->input->post('data');
        $page_id  =   $this->input->post('page_id');
        $user_id  =   $this->input->post('user_id');
        $subs_name  =  $this->input->post('subs_name');    
        
        $qry = " SELECT * FROM `messenger_bot_subscriber` where user_id=$user_id and page_id='$page_id' and (first_name LIKE '%$subs_name%' OR full_name LIKE '%$subs_name%')  ";
        $r = $this->db->query($qry)->result();
        echo json_encode($r);
    }    
    
	public function ext_send_test_ajax_php(){

        $this->ajax_check();
        $result  =   $this->input->post('data');
        $subscribe_id  =   $this->input->post('subscribe_id');
        
        $where_type['where'] = array('subscribe_id'=>$subscribe_id);
        $r = $this->basic->get_data('messenger_bot_subscriber',$where_type);
        $page_id = $r[0]['page_id'];
        $user_id = $r[0]['user_id'];     

        $where_type['where'] = array('page_id'=>$page_id,'user_id'=>$user_id);
        $token = $this->basic->get_data('facebook_rx_fb_page_info',$where_type);
        
        $where_type['where'] = array('postback_id'=>$result[0]['postbackid']);
        $json_message = $this->basic->get_data( 'messenger_bot_postback', $where_type, array("template_jsoncode") );
        $json_message_arr = json_decode( $json_message[0]['template_jsoncode'], true);
        
        $job['temp'] = $json_message_arr;
        $job['tag'] = "ACCOUNT_UPDATE";
        $job['subscribe_id'] = $subscribe_id;
        $job['page_access_token_send'] = $token[0]['page_access_token'];
        
        if($r[0]['first_name'] == ""){
            if($r[0]['full_name'] == ""){
                $job['fname'] = "Visitor";
                $job['lname'] = "!";
            }else{
                $name_arr = explode(" ",$r[0]['full_name']);
                $job['fname'] = $name_arr[0];
                $job['lname'] = $name_arr[1];
            }
        }else{
            $job['fname'] = $r[0]['first_name'];
            $job['lname'] = $r[0]['last_name'];            
        }

        $output = $this->ext_send_api_tag_flow_builder($job);
        echo json_encode($output);
    
    }
    
	public function ext_send_api_tag_flow_builder($job){
        
        
        $tag = $job['tag'];
        $subscribe_id = $job['subscribe_id'];
        $page_access_token_send = $job['page_access_token_send'];
        $temp  = $job['temp'];
        $first_name = $job['fname'];
        $last_name = $job['lname'];
        
        $errors = array();
        $sent_response = array();
        $message_array = $temp;
        $p=0;
        $curdate=date("Y-m-d H:i:s"); 
        foreach($message_array as $msg)
        {
            $p++;
            $template_type_file_track=$msg['message']['template_type'];
            unset($msg['message']['template_type']);
        
            $enable_typing_on = $msg['message']['typing_on_settings'];
            $enable_typing_on = ($enable_typing_on=='on')  ? 1 : 0;
            unset($msg['message']['typing_on_settings']);
            $typing_on_delay_time = $msg['message']['delay_in_reply'];
            if($typing_on_delay_time=="") $typing_on_delay_time = 0;
            unset($msg['message']['delay_in_reply']);
        
            if( array_key_exists('text',$msg['message']) ){
                if($msg['message']['text'] != ""){
                    $msg['message']['text'] = $this->ext_spintax_process_flow_builder($msg['message']['text']);    
                }
            }
            
            $msg['messaging_type'] = "UPDATE";
            
            if($tag != ""){
                $msg['messaging_type'] = "MESSAGE_TAG";
                $msg["tag"]= $tag;
            }
            
            $campaign_message_send = json_encode($msg); 
            $campaign_message_send = str_replace('#LEAD_USER_FIRST_NAME#',$first_name,$campaign_message_send);
            $campaign_message_send = str_replace('#LEAD_USER_LAST_NAME#',$last_name,$campaign_message_send);
        
            $replace_search=array('{"id":"replace_id"}','#SUBSCRIBER_ID_REPLACE#');
            $replace_with=array('{"id":"'.$subscribe_id.'"}',$subscribe_id);
            $campaign_message_send = str_replace($replace_search, $replace_with, $campaign_message_send);
                                  
            $error_count=0;
            try
            {
        
                $response = $this->ext_send_non_promotional_message_subscription_flow_builder($campaign_message_send,$page_access_token_send);
            
                if(isset($response['message_id']))
                {
                    $sent_response[] = $response['message_id']; 
                }
                else 
                {
                    if(isset($response["error"]["message"])) $sent_response[] = $response["error"]["message"];  
                    $error_count++;                 
                }
                
            }
            catch(Exception $e) 
            {
              $errors[] = $e;
              $error_count++;
            }
        }
        
        return array("results"=>$sent_response,"errors"=>$errors, "data"=>$job);
        
    }
    
	public function ext_send_non_promotional_message_subscription_flow_builder($message='[]',$post_access_token=''){
    	$url = "https://graph.facebook.com/v4.0/me/messages?access_token={$post_access_token}";
    
    	$ch = curl_init();
    	$headers = array("Content-type: application/json");
    
    	curl_setopt($ch, CURLOPT_URL, $url);
    	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	curl_setopt($ch,CURLOPT_POST,1);
    	curl_setopt($ch,CURLOPT_POSTFIELDS,$message);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  
    	curl_setopt($ch, CURLOPT_COOKIEJAR,'cookie.txt');  
    	curl_setopt($ch, CURLOPT_COOKIEFILE,'cookie.txt');  
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  
    	curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.3) Gecko/20070309 Firefox/2.0.0.3");   
    	$st = curl_exec($ch);  
    	$result = json_decode($st,TRUE);
    	return $result;
    	
    }
    
	public function ext_spintax_process_flow_builder($text){
        return preg_replace_callback(
            '/\{(((?>[^\{\}]+)|(?R))*)\}/x',
            "ext_spintax_replace_flow_builder",
            $text
        );
    }
    
	public function ext_spintax_replace_flow_builder($text){
        $text = $this->ext_spintax_process_flow_builder($text[1]);
        $parts = explode('|', $text);
        return $parts[array_rand($parts)];
    }
    
	public function ext_get_sequences_data(){
        
        $this->ajax_check();
        $user_id = $this->input->post('user_id');
        
        $sql = "SELECT email FROM `users` where id=$user_id;";
        $r = $this->db->query($sql)->row_array();
        $owner = $r['email'];
        $sequences = $this->ext_get_sequences($owner);
        echo json_encode($sequences);
        exit();
    }
    
	public function ext_get_email_sequences_data(){
        $this->ajax_check();
        $user_id = $this->input->post('user_id');
        $sequences = array();
        $template_table = $this->db->query(" SHOW TABLES LIKE 'ext_sequences'; ")->row_array();
        if($template_table){
            $_emails = $this->basic->get_data('ext_sequences',array("where"=>array("user_id"=>$user_id)),array("id","name"),"");
            foreach($_emails as $k => $_email){
                $url = $this->generate_email_webhook_url( $_email['id'] );
                $sequences[] = array("url" => $url, "name" => $_email['name'] );
            }
        }
        echo json_encode($sequences);
        exit();
    }    
    
    public function ext_get_sequences($owner){
        $payload = json_encode(array("owner"=>$owner));
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://apps.fbmarketingmaster.com/ext/wp-json/api/fbmm/getsequeces",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS =>$payload,
          CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json"
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true);        
    }
    
	public function ext_insert_db_webhook_sequence_data($webhook_name, $user_id, $fb_page_id, $page_name, $sequence_post_url, $owner, $type, $postback_id){
	    
        $a = $b = $thirdparty_webhook = $trigger_id = false;
        $webhook_url = $sequence_post_url;
        $sequence_post_url = str_replace("https://apps.fbmarketingmaster.com/ext/wp-json/api/webhook/","",$sequence_post_url);
        $hash = base64_encode($sequence_post_url);
        $unique_id = $postback_id."_".$hash;
        
        switch($type){
            case "user_input":
            case "trigger_messenger":
                $trigger_option = "trigger_postback_".$postback_id;
            break;
            case "trigger_email":
                $trigger_option = "trigger_email";
            break;
            case "trigger_phone_number":
                $trigger_option = "trigger_phone_number";
            break;          
        }    
        
        $sql = " SELECT id,webhook_id FROM `messenger_bot_thirdparty_webhook_trigger` where unique_id='$unique_id';  ";
        $r = $this->db->query($sql)->row_array();        
        if($r){
            
            $Table1Data = array(
                "name" => $webhook_name,
                "webhook_url" => $webhook_url,
            );
            $Table1where = array('id'=>$r['webhook_id']);
            $a = $this->basic->update_data('messenger_bot_thirdparty_webhook',$Table1where,$Table1Data);
            
            $Table2Data = array(
            	"trigger_option" => $trigger_option
            );
            $Table2where = array('id'=>$r['id']);
            $b = $this->basic->update_data('messenger_bot_thirdparty_webhook_trigger',$Table2where,$Table2Data);
            
            if($a && $b){
                return array("status"=>1,"notice"=>"Success updating $webhook_name","data"=>array($r['webhook_id'],$r['id'],$a,$b));
            }else{
                return array("status"=>0,"notice"=>"Error updating $webhook_name","data"=>array($r['webhook_id'],$r['id'],$a,$b));
            }
        }else{
            
            $data1 = array(
                "name" => $webhook_name,
                "user_id" => $user_id,
                "page_id" => $fb_page_id,
                "page_name" => $page_name,
                "webhook_url" => $webhook_url,
                "variable_post" => "psid,subscribed_at,postbackid,first_name,last_name,email,page_id,page_name,phone_number,labels,formdata,birthdate",
                "added_date" => date("Y-m-d H:i:s"),
                "last_trigger_time" => "0000-00-00 00:00:00",
            );
            $this->db->insert('messenger_bot_thirdparty_webhook', $data1);
            $thirdparty_webhook = $this->db->insert_id();
            
            $row_arrays = array(                        
            	"webhook_id" => $thirdparty_webhook,
            	"trigger_option" => $trigger_option,
                'unique_id' => $unique_id      	
            );
            $this->db->insert('messenger_bot_thirdparty_webhook_trigger', $row_arrays);
            $trigger_id = $this->db->insert_id();
            
            if($trigger_id && $thirdparty_webhook){
                return array( "status"=>1,"notice"=>"Success Saving $webhook_name Sequence Webhook!", "data"=>array($thirdparty_webhook,$trigger_id) );    
            }else{
                return array( "status"=>0,"notice"=>"Error Saving $webhook_name", "data"=>array($thirdparty_webhook,$trigger_id) );
            }
            
        }
    
    }
    
    public function ext_get_fields($post_id){
        $payload = json_encode(array("post_id"=>$post_id));
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://apps.fbmarketingmaster.com/ext/wp-json/api/fbmm/getfields",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS =>$payload,
          CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json"
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true);
    }
    
	public function ext_delete_flow_action_ajax(){
        
        $this->ajax_check();
        $post_id  =   $this->input->post('post_id');
        
        if(!$post_id){echo "No post ID submitted"; return FALSE;}
        
        try{
            $sql = " SELECT json_template FROM `ext_flow_builder` where id=$post_id; ";
            $json_template = $this->db->query($sql)->row_array();
            $result = json_decode($json_template['json_template'], true);
            foreach($result as $k=>$data){
                
                $postback_id = $data['postbackid'];
                
                $sql = " DELETE FROM `messenger_bot` where postback_id='$postback_id' ";
                $this->db->query($sql);
                
                $sql = " DELETE FROM `messenger_bot_postback` where postback_id='$postback_id'; ";
                $this->db->query($sql);
                
            }
        }catch(Exception $e){
            
        }
        
        $sql = " DELETE from ext_flow_builder where id=$post_id; ";
        $output = $this->db->query($sql);        
        
        if($output){
            $this->_delete_usage_log(777, 1, $this->user_id );
            echo "The post was successfully deleted";
            return TRUE;
        }else{
            echo "Error: Unknown error occured";
            return FALSE;
        }
        
    }
    
	public function ext_whitelist_domain_ajax(){
        
        $this->ajax_check();
        $urls_raw  =   $this->input->post('urls');
        $fb_page_id  =   $this->input->post('page_id');
        $user_id  =   $this->input->post('user_id');        
        
        if(array_key_exists('domains',$urls_raw)){
            $urls = $urls_raw['domains'];
        }else{
            echo json_encode(array('No domains found for whitelisting'));
            exit();
        }
        
        $page_data = $this->ext_get_user_page_row_id($user_id,$fb_page_id);
        $page_data = $page_data[0];
        $page_id = $page_data['id'];
        $access_token = $page_data['page_access_token'];        
        
        $output = $this->ext_domain_white_list_action($urls,$access_token);
        echo json_encode($output);
        return false;
        
    }
    
	public function ext_domain_white_list_action($urls,$access_token){
        $domain_list = array();
        if(is_array($urls)){
            foreach($urls as $url){
                $domain_arr = parse_url($url);
                if($domain_arr['scheme'] != "https"){
                    return array("status"=>0,"notice"=>"Error: Domain is not SSL Secured. Please use HTTPS");
                }
                $domain_list[] = $domain_arr['scheme']."://".$domain_arr['host'];                   
            }
        }else{
            $domain_arr = parse_url($urls);
            if($domain_arr['scheme'] != "https"){
                return array("status"=>0,"notice"=>"Error: Domain is not SSL Secured. Please use HTTPS");
            }
            $domain_list[] = $domain_arr['scheme']."://".$domain_arr['host'];
        }

        $json = array(
            "setting_type"          => "domain_whitelisting",
            "whitelisted_domains"   => $domain_list,
            "domain_action_type"    => "add"
        );
        
        $payload = json_encode($json, true);
        $url = "https://graph.facebook.com/v4.0/me/messenger_profile?access_token=".$access_token;
        $ch = curl_init( $url );
        curl_setopt( $ch, CURLOPT_POSTFIELDS, $payload );
        curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        
        $result = curl_exec($ch);
        $err = curl_error($ch);
        
        curl_close($ch);
        
        if ($err) {
            return $err;
        } else {
            return json_decode($result);
        }  
        
    }
    
	public function ext_get_user_comment_replies(){

        
        $is_new = true;
        $this->ajax_check();
        $user_id  =   $this->input->post('user_id');
        $fb_page_id  =   $this->input->post('page_id');        
        
        $page_data = $this->ext_get_user_page_row_id($user_id,$fb_page_id);
        $page_info_table_id = $page_data[0]['id'];
        
        $table_type = 'facebook_ex_autoreply';
        $where_type['where'] = array('user_id'=>$user_id,"page_info_table_id"=>$page_info_table_id);
        $r = $this->basic->get_data($table_type,$where_type);        
    
        echo json_encode($r);
        return false;

    }
    
	public function ext_share_flow(){
        
        $this->ajax_check();
        $user_id  =   $this->input->post('user_id');
        $user_email  =   $this->input->post('user_email');
        $OriginPost_id  =   $this->input->post('post_id');
        
        //Flow Owner
        $post_id = false;
        $data = $this->db->query(" SELECT email,name FROM `users` where id=".$user_id)->row_array();
        $name = $data['name'];
        
        //Flow Recepeint
        $Recepeint = $this->db->query(" SELECT id,email,name FROM `users` where email='$user_email' ")->row_array();
        $Recepeint_user_id = $Recepeint['id'];
        
        //Flow DB Data
        $flow = $this->db->query(" SELECT * FROM `ext_flow_builder` WHERE id=".$OriginPost_id)->row_array();
        
        $flowName = "SHARED FLOW: ".$flow['name']." (Shared By: $name)";
        $flow_data = $flow['flow_data'];
        $page_id = "";
        $page_name = "";
        $fb_page_id = "";
        $result = $flow['json_template'];
        
        $post_id = $this->ext_create_new_flow($Recepeint_user_id, $page_id, $page_name, $fb_page_id, $flowName, $result, $flow_data );

        if($post_id){
            $output = array("status"=>1,"notice"=>"Successfully shared Flow!","data"=>$post_id);
        }else{
            $output = array("status"=>0,"notice"=>"Failed to share Flow.","data"=>"");
        }
        
        echo json_encode($output);
        return false;
        
    }
    
    public function ext_is_user_valid_api_ajax(){
    
        $this->ajax_check();
        $user_email  =   $this->input->post('user_email');
        
        $email = isset($_POST['user_email'])?$_POST['user_email']:FALSE;
        if(!$email){
            echo 'FALSE';
            return FALSE;
        }
        
        //Flow Recepeint
        $user = $this->db->query(" SELECT email FROM `users` where email='$user_email' ")->row_array();
        if($user){
            $output = array("status"=>1,"notice"=>"User is valid.");    
        }else{
            $output = array("status"=>0,"notice"=>"User is Invalid.");
        }
        
        echo json_encode($output);
        return TRUE;
        
    }    
    
    public function ext_get_user_page_row_id($user_id,$page_id){
    
        $table_type = 'facebook_rx_fb_page_info';
        $where_type['where'] = array('user_id'=>$user_id,"page_id"=>$page_id);
        $info_type = $this->basic->get_data($table_type,$where_type);
        
        return $info_type;
        
    }
    
    public function ext_get_user_pages($user_id){
        $table_type = 'facebook_rx_fb_page_info';
        $where_type['where'] = array('user_id'=>$user_id,"bot_enabled"=>"1");
        $info_type = $this->basic->get_data($table_type,$where_type);
        return $info_type;
    }
    
    public function activate(){
        
        $this->ajax_check();
        $this->init_db_flow_builder();
        $this->init_db_template();
        $addon_controller_name=ucfirst($this->router->fetch_class());
        $purchase_code=$this->input->post('purchase_code');
        $domain = get_domain_only(site_url());
        $result = $this->verify_purchase_code($purchase_code,$domain);
        if($result['status'] == 1){
            $this->register_addon($addon_controller_name,array(),array(),$purchase_code); exit();
        }else{
            echo json_encode(array('status'=>'0','message'=>$this->lang->line($result['notice'])));exit();
        }

    }
    
    public function verify_purchase_code($purchase_code,$domain){
        
        $payload = json_encode(array(
            "purchase_code" => $purchase_code,
            "domain" => base64_encode($domain),
            "item_id" => base64_encode("Flow Builder - A Must Have Addon For Xerochat SaaS (by Colin)")
        ));
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://apps.fbmarketingmaster.com/ext/wp-json/fbmm/flowbuilder/register",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS =>$payload,
          CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json"
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true);
    }
    
    public function deactivate(){
        
        $this->ajax_check();
        $addon_controller_name=ucfirst($this->router->fetch_class());
        $install_txt_path=APPPATH."modules/".strtolower($addon_controller_name)."/install.txt";
        if(!file_exists($install_txt_path)) // putting install.txt
        fopen($install_txt_path, "w");
        $menu = $this->db->query(" SELECT id FROM `menu` where url LIKE '%flow_builder%' ")->row_array();
        $menu_id = $menu[id];        
        $this->db->query(" DELETE FROM `menu` WHERE `menu`.`id` = $menu_id ");
        $this->db->query(" DELETE FROM `add_ons` WHERE `unique_name` = 'flow_builder' ");
        echo json_encode(array('status'=>'1','message'=>$this->lang->line('Add-on has been deactivated successfully.')));exit();
        
    }
    
    public function update(){
        
        $output = array("success"=>array(),"failed"=>array());
        $this->ajax_check();
        $addon_controller_name=ucfirst($this->router->fetch_class());
        $addon_path = APPPATH."modules/".strtolower($addon_controller_name);

        $isValid = $this->ext_validate_update();
        if($isValid['status'] != 1){
            echo json_encode(array("status"=>0,"notice"=>"Sorry, you have no access to updates."));
            exit();
        }
        
        $fileUrl = base64_decode($isValid['hash']);
        
        $path = APPPATH."modules/ext_download";
        if (!file_exists($path)) {
            mkdir($path, 0755, true);
        }
        
        $saveTo = $path."/flow_builder_updater.zip";
        $fp = fopen($saveTo, 'w+');
        if($fp === false){
            echo json_encode(array("status"=>0,"notice"=>"Error: Could not access the save path.."));
            exit();
        }
        
        $ch = curl_init($fileUrl);
        curl_setopt($ch, CURLOPT_FILE, $fp);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_exec($ch);
        if(curl_errno($ch)){
            echo json_encode(array("status"=>0,"notice"=>Exception(curl_error($ch))));
            exit();
        }
        
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        fclose($fp);
         
        if($statusCode == 200){
            $zip = new ZipArchive;
            if ($zip->open($saveTo) === TRUE) {
                $zip->extractTo($path);
                $zip->close();
                
                if (file_exists(APPPATH."modules/ext_download/flow_builder")) {
                    
                    $TheFile = APPPATH."modules/ext_download/flow_builder/file_update_pool.txt";
                    $file_update_pool = unserialize(file_get_contents($TheFile));
                    if(!file_exists($TheFile)){
                        $this->ext_delete_files($path);
                        echo json_encode(array("status"=>0,"notice"=>"Error: The map of files for updating could not be found..."));
                        exit();
                    }
            
                    $OriginalFiles = $this->ext_getDirContents($addon_path);
                    foreach($OriginalFiles as $key=>$file){
                        $_file = str_replace(APPPATH,"",$file);
                        if(in_array($_file,$file_update_pool)){
                            $newfile = str_replace("flow_builder","ext_download/flow_builder",$file);
                            if(file_exists($newfile)){
                                if (!copy($newfile, $file)) {
                                    $output["failed"][] = $file;
                                }else{
                                    $output["success"][] = $file;
                                }
                            }
                        }            
                    }
                    
                    $this->ext_delete_files($path);
                    echo json_encode(array("status"=>1,"notice"=>"Success: The update operation was complete!","data"=>$output));
                    exit();
                    
                    
                }else{
                    
                    $this->ext_delete_files($path);
                    echo json_encode(array("status"=>0,"notice"=>"Error: Failed to extract the update file."));
                    exit();
                    
                }
                
            }else{
                $this->ext_delete_files($path);
                echo json_encode(array("status"=>0,"notice"=>"Error: Could not open the update bundle"));
                exit();
            }
            
        }else{
            echo json_encode(array("status"=>0,"notice"=>"Error: Could not download the update file."));
            exit();
        }
    }
    
    public function ext_getDirContents($dir, &$results = array()) {
        $files = scandir($dir);
        foreach ($files as $key => $value) {
            $path = realpath($dir . DIRECTORY_SEPARATOR . $value);
            if (!is_dir($path)) {
                $results[] = $path;
            } else if ($value != "." && $value != "..") {
                $this->ext_getDirContents($path, $results);
                $results[] = $path;
            }
        }
    
        return $results;
    }
    
    function ext_delete_files($target){
        if(is_dir($target)){
            $files = $this->ext_getDirContents($target);
            foreach( $files as $file ){
                $this->ext_delete_files( $file );
            }
    
            rmdir( $target );
        } elseif(is_file($target)) {
            unlink( $target );  
        }
    }     
    
    public function need_update(){
        if($this->session->userdata('user_type') == "Admin"){
            $result = $this->version_check_api();
            if( $result['version'] != $this->version ){
                return 'true';
            }else{
                return 'false';
            }            
        }else{
            return 'false';
        }
        return 'false';
    }
    
    public function version_check_api(){
        $curl = curl_init();
        $payload = json_encode(array("item_id"=>1));
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://apps.fbmarketingmaster.com/ext/wp-json/fbmm/flowbuilder/v2/version",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $payload,
          CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true);
    }

    public function delete(){
        
        $this->ajax_check();
        $purchase_code = "";
        $domain = get_domain_only(site_url());
        $r = $this->db->query(" SELECT * FROM `add_ons` where unique_name = 'flow_builder' ")->row_array();
        if($r){
            $purchase_code = $r['purchase_code'];
        }
        $result = $this->delete_domain_action($domain,$purchase_code);
        if($result['status'] == 1){
            $addon_controller_name=ucfirst($this->router->fetch_class());
            $menu = $this->db->query(" SELECT id FROM `menu` where url LIKE '%flow_builder%' ")->row_array();
            if($menu){
                $menu_id = $menu['id'];
                $this->db->query(" DROP TABLE `ext_flow_builder` ");
                $this->db->query(" DELETE FROM `menu` WHERE `menu`.`id` = $menu_id ");   
                $this->db->query(" DELETE FROM `add_ons` where unique_name = 'flow_builder' ");
            }
            $addon_path = APPPATH."modules/".strtolower($addon_controller_name);
            $this->delete_directory($addon_path);
            echo json_encode(array('status'=>'1','message'=>$this->lang->line('add-on has been deleted successfully.')));
        }else{
            echo json_encode(array('status'=>'0','message'=>$this->lang->line('Database error. Something went wrong. ')));
        }

    }
    
    public function delete_domain_action($domain,$purchase_code){
        
        $payload = json_encode(array(
            "domain"=>base64_encode($domain),
            "purchasecode"=>$purchase_code
        ));
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://apps.fbmarketingmaster.com/ext/wp-json/fbmm/flowbuilder/delete",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS =>$payload,
          CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json"
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response,true);
    }
    
    public function init_db_flow_builder(){
        try{
            $sql = "CREATE TABLE IF NOT EXISTS `ext_flow_builder` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `page_id` int(11) NULL DEFAULT NULL,
              `page_name` mediumtext COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,  
              `fb_page_id` varchar(200) COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
              `name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
              `json_template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
              `flow_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
              `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
              PRIMARY KEY (`id`),
              KEY `user_id` (`user_id`,`page_id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
             $this->db->query($sql);
        }catch(Exception $e){
            
        }

        $menu_exists = $this->db->query(" SELECT id FROM `menu` where url LIKE '%flow_builder%' ")->row_array();
        if(!$menu_exists){
            try{
                $sql = "INSERT INTO `menu` (`name`, `icon`, `url`, `serial`, `module_access`, `have_child`, `only_admin`, `only_member`, `add_ons_id`, `is_external`, `header_text`)
                VALUES ('Flow Builder', 'fas fa-project-diagram', 'flow_builder', 29, '', '0', '0', '0', 0, '0', '');" ;
                $this->db->query($sql);
            }catch(Exception $e){

            }
        }
    }
    
	public function unlicenced(){
    	$data['page_info'] = array();
    	$data['body'] = 'unlicensed';
    	$data['page_title'] = "Flow Builder";
    	$this->_viewcontroller($data);
	}
    
    public function ext_get_user_page_labels($page_id,$user_id){
        $table_type = 'messenger_bot_broadcast_contact_group';
        $where_type['where'] = array('user_id'=>$user_id,"page_id"=>$page_id);
        $user_labels = $this->basic->get_data($table_type,$where_type);
        return $user_labels;
    }
    
    public function ext_populate_user_labels(){
        $output = array();
        $this->ajax_check();
        $user_id  =   $this->input->post('user_id');
        $fb_page_id = $this->input->post('fb_page_id');
        
        $page_data = $this->ext_get_user_page_row_id($user_id,$fb_page_id);
        $page_info_table_id = $page_data[0]['id'];
        $labels = $this->ext_get_user_page_labels($page_info_table_id,$user_id);
        
        foreach($labels as $label){
            
            $label_name = $label['group_name'];
            $label_id = $label['id'];
            
            if( $label_name != 'Unsubscribe' && $label_name != 'SystemInvisible01' ){
                $output[ $label_id ] = $label_name;  
            }
            
        }
        
        echo json_encode($output);
        
    }
    
    public function ext_get_user_post_back_ids(){

        $is_new = true;
        $this->ajax_check();
        $user_id  =   $this->input->post('user_id');
        $page_id  =   $this->input->post('page_id');
        
        $table_type = 'messenger_bot';
        $where_type['where'] = array('user_id'=>$user_id,"fb_page_id"=>$page_id);
        $postbacks = $this->basic->get_data($table_type,$where_type);

        echo json_encode($postbacks);
        
    }
    
    public function get_template(){
        $this->ajax_check();
        $type  =   $this->input->post('type');
        $template_data = $this->db->query(" SELECT flow_data FROM ext_flow_builder_template WHERE id=$type ")->row_array();
        echo $template_data['flow_data'];
        
    }
    
    public function ext_file_upload(){

            $folder_path = FCPATH."upload/flow_builder";
            if (!file_exists($folder_path)) {
                mkdir($folder_path, 0777, true);
            }
            
            $upload_dir = FCPATH."upload/flow_builder/".$this->user_id;
            if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
    
           if (isset($_FILES['fileToUpload'])) {
    
                $file_size = $_FILES['fileToUpload']['size'];
                if ($file_size > 5242880) {
                    $message = 'The file size exceeds the limit. Allowed size is 5MB. Please remove the file and upload again.';
                    echo json_encode(['error' => $message]);
                    exit;
                }
                
                // Holds tmp file
                $tmp_file = $_FILES['fileToUpload']['tmp_name'];
    
                if (is_uploaded_file($tmp_file)) {
    
                    $post_fileName = $_FILES['fileToUpload']['name'];
                    $post_fileName_array = explode('.', $post_fileName);
                    $ext = array_pop($post_fileName_array);
    
                    $allow_ext = ['pdf', 'doc', 'txt', 'png', 'jpg', 'jpeg', 'gif', 'zip','mp4', 'pptx', 'docx', 'xls', 'xlsx', 'csv', 'ppt'];
                    if(! in_array(strtolower($ext), $allow_ext)) {
                        $message = 'Are you kidding???';
                        echo json_encode(['error' => $message]);
                        exit;
                    }
    
                    $filename = implode('.', $post_fileName_array);
                    $filename = strtolower(strip_tags(str_replace(' ', '-', $filename)));
                    $filename = $filename . '_' . time() . substr(uniqid(mt_rand(), true), 0, 6) . '.' . $ext;
    
                    // Moves file to the upload dir
                    $dest_file = $upload_dir . DIRECTORY_SEPARATOR . $filename;
                    if (! @move_uploaded_file($tmp_file, $dest_file)) {
                        $message = 'That was not a valid upload file.';
                        echo json_encode(['error' => $message]);
                        exit;
                    }
    
                    // Returns response
                    echo json_encode([ 'filename' => $filename]);
                }
           }        
        
    }
    
    public function store_addon_data_to_db( $add_on_name, $unique_name, $purchase_code, $module_folder_name){
        
        $r = $this->db->query(" SELECT * FROM `add_ons` where unique_name = 'flow_builder' ")->row_array();
        if(!$r){
            try{
                
                $row_arrays = array(
                    'add_on_name' => $add_on_name,
                    'unique_name' => $unique_name,
                    'version' => $this->version,
                    'installed_at' => date("Y-m-d H:i:s"),
                    'update_at' => '0000-00-00 00:00:00',
                    'purchase_code' => $purchase_code,
                    'module_folder_name' => $module_folder_name,
                    'project_id' => 77,
                );
                
                $this->db->insert('add_ons', $row_arrays);
                $id = $this->db->insert_id();
                return $id;
                
            }catch(Exception $e){
                $errors[] = $e->getMessage();
            }
        }else{
            if($r['version'] == $this->version){
                return;
            }
            $TableData = array(
                'version' => $this->version,
                'update_at' => date("Y-m-d H:i:s"),
            );
            $Tablewhere = array('id'=>$r['id']);
            $this->basic->update_data('add_ons',$Tablewhere,$TableData);
        }
    }
    
    public function update_addon_data_to_db(){
        
        $r = $this->db->query(" SELECT * FROM `add_ons` where unique_name = 'flow_builder' ")->row_array();
        if(!$r){
            return;
        }else{
            if($r['version'] == $this->version){
                return;
            }
            
            $version = $this->version."";
            $TableData = array(
                'version' => $version,
                'update_at' => date("Y-m-d H:i:s"),
            );
            $Tablewhere = array('id'=>$r['id']);
            $this->basic->update_data('add_ons',$Tablewhere,$TableData);
        }
        
    }
    
    public function register_addon_manager(){
        
        $r = $this->db->query(" SELECT * FROM `add_ons` where unique_name = 'flow_builder' ")->row_array();
        if(!$r){
            return;
        }
        
        $add_ons_id = $r["id"];
        
        $addon_controller_name = ucfirst($this->router->fetch_class());
        $path = APPPATH."modules/".strtolower($addon_controller_name)."/controllers/".$addon_controller_name.".php"; // path of addon controller
        if(!file_exists($path))
        {
            echo json_encode(array('status'=>'0','message'=>$this->lang->line('Add-on controller not found.')));
            exit();
        }        
        
        $addon_data = $this->get_addon_data($path);
        $modules = isset($addon_data['modules']) ? json_decode(trim($addon_data['modules']),true) : array();
        if(json_last_error() === 0 && is_array($modules))
        {
            foreach($modules as $key => $value)
            {
                if(!$this->basic->is_exist("modules",array("id"=>$key))) 
                $this->basic->insert_data("modules",array("id"=>$key,"extra_text"=>$value['extra_text'],"module_name"=>$value['module_name'],'bulk_limit_enabled'=>$value['bulk_limit_enabled'],'limit_enabled'=>$value['limit_enabled'],"add_ons_id"=>$add_ons_id,"deleted"=>"0"));
            }
        }        
    }
    
    public function ext_validate_update(){
        
        $r = $this->db->query(" SELECT * FROM `add_ons` where unique_name = 'flow_builder' ")->row_array();
        if(!$r){return;}
        
        $purchase_code = $r['purchase_code'];
        $domain = get_domain_only(site_url());
        $payload = json_encode(array(
            "purchase_code" => $purchase_code,
            "domain" => base64_encode($domain),
            "item_id" => base64_encode("Flow Builder - A Must Have Addon For Xerochat SaaS (by Colin)")
        ));
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://apps.fbmarketingmaster.com/ext/wp-json/fbmm/flowbuilder/update",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS =>$payload,
          CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json"
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true);        
    }
    
    public function init_db_template(){
        try{
            $sql = "CREATE TABLE IF NOT EXISTS `ext_flow_builder_template` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `img_url` varchar(200) COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
              `name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
              `flow_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
              `template_id` VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
              `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
              PRIMARY KEY (`id`),
              KEY `user_id` (`user_id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
             $this->db->query($sql);
        }catch(Exception $e){
            
        }
        
        $template_table = $this->db->query(" SHOW TABLES LIKE 'ext_flow_builder_template'; ")->row_array();
        if($template_table){
            $tableHasValue = $this->db->query(" SELECT * FROM `ext_flow_builder_template` ")->row_array();
            if( count($tableHasValue) < 1 ){
                try{
                    $templates = $this->get_init_templates();
                    foreach($templates as $hash=>$data){
                        $profile = json_decode(base64_decode($hash),true);
                        $name = $profile['name'];
                        $img_url = $profile['img'];
                        $flow_data = $data;
                        $this->ext_create_new_template($this->user_id, $img_url, $name, $flow_data );
                    }
                }catch(Exception $e){
                    
                }                      
            }
        }
        
        $maintable = $this->db->query(" SHOW TABLES LIKE 'ext_flow_builder'; ")->row_array();
        if($maintable){
            $template_table = $this->db->query(" SHOW COLUMNS FROM `ext_flow_builder` LIKE 'template_id'; ")->row_array();
            if(empty($template_table)){
                $this->db->query(" ALTER TABLE `ext_flow_builder` ADD `template_id` VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL AFTER `flow_data`; ");
            }             
        };
    }
    
    public function get_init_templates(){
        $output = array();
        $types = array(
            'realestate'=>array('name'=>'Real Estate','img'=>'https://image.flaticon.com/icons/svg/609/609803.svg'),
            'ecommerce'=>array('name'=>'E-commerce','img'=>'https://image.flaticon.com/icons/svg/572/572806.svg'),
            'restaurant'=>array('name'=>'Restaurant','img'=>'https://image.flaticon.com/icons/svg/1034/1034658.svg'),
            'travel'=>array('name'=>'Travel and Tours','img'=>'https://image.flaticon.com/icons/svg/776/776531.svg'),
            'mlm'=>array('name'=>'Multi-Level Marketing','img'=>'https://image.flaticon.com/icons/svg/1967/1967187.svg'),
            'insurance'=>array('name'=>'Insurance Company','img'=>'https://image.flaticon.com/icons/svg/1518/1518706.svg'),
            'cardealer'=>array('name'=>'Car Dealership','img'=>'https://image.flaticon.com/icons/svg/364/364603.svg'),
            'gym'=>array('name'=>'Gym','img'=>'https://image.flaticon.com/icons/svg/502/502128.svg')
        );
        $addon_controller_name=ucfirst($this->router->fetch_class());
        foreach($types as $type=>$profile){
            $raw_data = APPPATH."modules/".strtolower($addon_controller_name)."/templates/$type.txt";
            $hash = base64_encode(json_encode($profile));
            $output[$hash] = file_get_contents($raw_data);
        }
        return $output;
    }    
    
    public function ext_create_new_template($user_id, $img_url, $name, $flow_data ){
        $errors = array();
        try{
            
            $row_arrays = array(
                'user_id' => $user_id,
                'img_url' => $img_url,
                'name' => $name,
                'flow_data' => $flow_data,
            );
            
            $this->db->insert('ext_flow_builder_template', $row_arrays);
            $post_id = $this->db->insert_id();
            return $post_id;
            
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }        
        return $errors;
    }
    
    public function ext_create_new_template_ajax(){
        
        try{
            $post_id = $img_url = $name = $user_id = $template_id = "";
            $this->ajax_check();
            $post_id = $this->input->post('post_id');
            $image_raw = $this->input->post('image');
            $user_id = $this->input->post('user_id');
            $image = base64_decode($image_raw);
            $img_url = site_url()."upload/flow_builder/$user_id/$image";
            $result = $this->db->query(" SELECT flow_data,name FROM `ext_flow_builder` WHERE id='$post_id'; ")->row_array();
            $flow_data = $result['flow_data'];
            $name = $result['name'];
            $template_id = $this->ext_create_new_template($user_id, $img_url, $name, $flow_data );
            if( $template_id && !is_array($template_id) ){
                try{
                    $row_arrays = array(
                        'template_id' => $template_id,
                    );
                    $where = array('id'=>$post_id);
                    $this->basic->update_data('ext_flow_builder',$where,$row_arrays);
                    echo json_encode(array("status"=>1,"notice"=>"Success! Creating a Template Completed!","data"=>array($img_url,$name,$user_id,$template_id)));
                    exit();
                }catch(Exception $e){
                    echo json_encode(array("status"=>0,"notice"=>"Failed! Creating a Template was not completed!","data"=>array($img_url,$name,$user_id,$post_id,$template_id,$e->getMessage())));
                    exit();                
                }
            }            
        }catch(Exception $e){
            echo json_encode(array("status"=>0,"notice"=>"Failed! Creating a Template was not completed!","data"=>array($img_url,$name,$user_id,$post_id,$template_id, $e->getMessage())));
            exit();
        }
        echo json_encode(array("status"=>0,"notice"=>"Failed! Creating a Template was not completed!","data"=>array($img_url,$name,$user_id,$post_id,$template_id)));
        exit();
    }
    
    public function ext_update_template_ajax(){
        $this->ajax_check();
        $image_raw = $this->input->post('image');
        $user_id = $this->input->post('user_id');
        $post_id = $this->input->post('post_id');
        $image = base64_decode($image_raw);
        $img_url = site_url()."upload/flow_builder/$user_id/$image";
        $output = $this->ext_update_template("", $post_id, "", $img_url);
    
        if($output){
            echo "true";
        }else{
            echo "false";
        }
        
    }

    public function ext_update_template($flow_data, $post_id, $name="", $img_url=""){
        
        try{
            
            if($flow_data){
                $row_arrays['flow_data'] = $flow_data;
            }
            
            if($img_url){
                $row_arrays['img_url'] = $img_url;
            }
            
            if($name){
                $row_arrays['name'] = $name;
            }
            
            $where = array('id'=>$post_id);
            $output = $this->basic->update_data('ext_flow_builder_template',$where,$row_arrays);
            return $output;
        }catch(Exception $e){
            $errors[] = $e->getMessage();
        }
        
        return false;
    }
    
	public function ext_get_templates_helper(){
        try{
            $table_type = 'ext_flow_builder_template';
            $where_type['where'] = array();
            $templates = $this->basic->get_data($table_type,$where_type);
            return $templates;            
        }catch(Exception $e){
            return array();
        }
    }
    
	public function ext_get_user_templates(){

        $data = $this->ext_get_templates_helper();
        foreach($data as $k=>$a){
            $name = $a['name'];
            $id = $a['id'];
            $img = $a['img_url'];
            
            $data[$k]['img'] = $img;
            $data[$k]['name'] = $name;
            $data[$k]['id'] = $id;
            
        }
        
        return $data;
        
    }
    
	public function ext_delete_template_action_ajax(){
        $output = array();
        $this->ajax_check();
        $post_id  =   $this->input->post('post_id');
        
        if(!$post_id){echo "No post ID submitted"; return FALSE;}
        
        try{
            $sql = " DELETE from ext_flow_builder_template where id='$post_id'; ";
            $output[] = $this->db->query($sql);
            
            $result = $this->db->query(" SELECT id FROM `ext_flow_builder` WHERE template_id = '$post_id'; ")->row_array();
            $flow_id = $result['id'];
            
            try{
                $row_arrays = array(
                    'template_id' => NULL,
                );
                $where = array('id'=>$flow_id);
                $this->basic->update_data('ext_flow_builder',$where,$row_arrays);
                echo json_encode(array("status"=>1,"notice"=>"The template was successfully deleted"));
                exit();
            }catch(Exception $e){
                echo json_encode(array("status"=>0,"notice"=>"Failed! Error: Unknown error occured!"));
                exit();
            }
            
        }catch(Exception $e){
                 
        }
        echo json_encode(array("status"=>0,"notice"=>"Failed! Error: Unknown error occured!"));
        exit();        
    }
    
    public function init_usage_log(){
        $user_id = $this->user_id;
        $has_usage_log = $this->db->query(" SELECT id FROM `usage_log` WHERE user_id = '$user_id' AND module_id = 777; ")->row_array();
        $has_used_flow = $this->db->query(" SELECT id FROM `ext_flow_builder` WHERE user_id = '$user_id' ; ")->row_array();
        if(!$has_usage_log && $has_used_flow){
            $usage_count = count($has_used_flow);
            $this->_insert_usage_log(777,$usage_count,$user_id);
        }
    }
    
    public function ext_check_usage_helper($module_id){
        
        if($this->session->userdata('user_type') == 'Admin'){
            return json_encode(array("status"=>1,"data"=>array()));
        }
        
        if($this->session->userdata('user_type') != 'Admin' && !in_array($module_id,$this->module_access)){
            $notice = $this->lang->line("You Do Not Have Access To This Feature. Pleaese Upgrade Your Account To Do More.");
            return json_encode(array("status"=>0,"notice"=>$notice));
        }
        
        $status = $this->_check_usage($module_id,$request=1);
        if($status=="2")
        {
            $notice = $this->lang->line("Sorry, your bulk limit is exceeded for this module.");
            return json_encode(array("status"=>0,"notice"=>$notice));
        }
        else if($status=="3")
        {
            $notice = $this->lang->line("Sorry, your monthly limit is exceeded for this module.");
            return json_encode(array("status"=>0,"notice"=>$notice));
        }else{
            return json_encode(array("status"=>1,"data"=>$status));
        }        
    }
    
    public function ext_check_usage(){
        
        $this->ajax_check();
        $module_id  =   $this->input->post('module_id');
        echo $this->ext_check_usage_helper($module_id);

    }
    
    public function delete_postbacks(){
        
        $this->ajax_check();
        $postback_id  =   $this->input->post('postback_id');        
        try{
            $sql1 = " DELETE FROM `messenger_bot` where postback_id='$postback_id' ";
            $a = $this->db->query($sql1);            
        }catch(Exception $e){
            $a = $e->getMessage();
        }
        
        try{
            $sql2 = " DELETE FROM `messenger_bot_postback` where postback_id='$postback_id'; ";
            $b = $this->db->query($sql2);
        }catch(Exception $e){
            $b = $e->getMessage();
        }        
        echo json_encode(array($a,$b,$postback_id));
        exit();
        
    }
    
    public function ext_check_if_email_flow_builder_exists(){
        $r = $this->db->query(" SELECT * FROM `add_ons` where unique_name = 'email_flow_builder' ")->row_array();
        if( !empty($r) ){
            return true;
        }
        return false;
    }
    
    public function get_flow_builder_script(){
        $is_exists = $this->ext_check_if_email_flow_builder_exists();
        if(!$is_exists){
            return "https://d32l7ypzfhd5bf.cloudfront.net/flow_builder/bundle.js";
        }else{
            return "https://pro.fbmarketingmaster.com/application/modules/lib_devA/dist/bundle.js";
        }
    }

    public function generate_email_webhook_url($sequence_id){
        $hash = json_encode(array("user_id"=>$this->user_id,"type"=>"trigger_email","id"=>$sequence_id));
        return site_url()."email_flow_builder/webhook_callback_main/?hash=".urlencode($this->ext_encrypt($hash));
    }
    
    public function ext_encrypt($string){
        $ciphering = "AES-128-CTR";
        $iv_length = openssl_cipher_iv_length($ciphering); 
        $options = 0;
        $encryption_iv = '1234567891011121'; 
        $encryption_key = "ChristumVosSalvis"; 
        $encryption = openssl_encrypt($string, $ciphering, 
        			$encryption_key, $options, $encryption_iv); 
    
        return $encryption; 
    }
    
    public function ext_decrypt($string){
        $ciphering = "AES-128-CTR";
        $decryption_iv = '1234567891011121';
        $decryption_key = "ChristumVosSalvis";
        $options = 0;
        $decryption=openssl_decrypt ($string, $ciphering,
        		$decryption_key, $options, $decryption_iv);
        return $decryption;
    }
    
    public function ext_get_my_otns(){
        $output = array();
        $this->ajax_check();
        $fb_page_id  =   $this->input->post('page_id');
        $user_id = $this->user_id;
        
        $page_data = $this->ext_get_user_page_row_id($user_id,$fb_page_id);
        $page_data = $page_data[0];
        $page_id_db = $page_data['id'];        
        
        $where = array("where"=>array("user_id"=>$user_id,"page_id"=>$page_id_db));
        $result = $this->basic->get_data('otn_postback',$where);
        echo json_encode($result);
        exit();
    }
    
    public function ext_create_new_otn_template($otn_name, $postback_id, $page_id_db, $user_id, $labels){
        
        $sql = " SELECT id FROM `messenger_bot_postback` where postback_id='$postback_id' ";
        $_postback_id_db = $this->db->query($sql)->row_array();
        $postback_id_db = $_postback_id_db["id"];
        
        $otn_postback_id = filter_var( $otn_name, FILTER_SANITIZE_EMAIL);
        
        $sql2 = " SELECT id FROM `otn_postback` where otn_postback_id='$otn_postback_id' and page_id = $page_id_db; ";
        $_otn_postback_id = $this->db->query($sql2)->row_array();
        
        $this->db->trans_start();
        
        if(!$_otn_postback_id){
            $data = array(
                "template_name" => strip_tags($otn_name),
                "user_id"=> $user_id,
                "page_id"=> strip_tags($page_id_db),
                "otn_postback_id" => strip_tags($otn_postback_id),
                "reply_postback_id" => strip_tags($postback_id_db),
                "label_id" => $labels,
                "drip_campaign_id" =>"",
                "deleted" => "0"
            );
            $this->basic->insert_data('otn_postback',$data);
            $output = $this->db->insert_id();
        }else{
            $data = array(
                "template_name" => strip_tags($otn_name),
                "reply_postback_id" => strip_tags($postback_id_db),
                "label_id" => $labels,
                "drip_campaign_id" =>"",
                "deleted" => "0"
            );
            $where = array("id"=>$_otn_postback_id["id"]);
            $this->basic->update_data('otn_postback',$where, $data);
            $output = $_otn_postback_id["id"];
        }
        
        $this->db->trans_complete();

        return $output;
        

    }
    
    public function test_call(){

    }
    
    public function update_file_log(){
        
        $output = array();
        $addon_controller_name=ucfirst($this->router->fetch_class());
        $addon_path = APPPATH."modules/".strtolower($addon_controller_name);        
        $dirs = $this->ext_getDirContents($addon_path);    
        foreach($dirs as $dir){
            $output[] = str_replace("/home/fbmarketingmast/public_html/pro/application/","",$dir);
        }        

        $data = serialize($output);
        $file = APPPATH."modules/".strtolower($this->router->fetch_class())."/file_update_pool.txt";
        file_put_contents($file, $data);
    }    
    
}