<?php
/*
Addon Name: Visual Flow Builder 
Unique Name: visual_flow_builder
Modules:
{
   "315":{
      "bulk_limit_enabled":"0",
      "limit_enabled":"0",
      "extra_text":"",
      "module_name":"Visual flow builder access"
   }
}
Project ID: 59
Addon URI: https://xerochat.com
Author: Xerone IT
Author URI: https://xeroneit.net
Version: 1.5
Description: 
*/

require_once("application/controllers/Home.php"); // loading home controller

class Visual_flow_builder extends Home
{
    /**
     * An array of php file upload errors
     *
     * @var array
     */
    protected $php_file_upload_errors = [
        0 => 'There is no error, the file uploaded with success',
        1 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
        2 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
        3 => 'The uploaded file was only partially uploaded',
        4 => 'No file was uploaded',
        6 => 'Missing a temporary folder',
        7 => 'Failed to write file to disk.',
        8 => 'A PHP extension stopped the file upload.',
    ];   

    public $addon_data=array(); 

    public function __construct()
    {
        parent::__construct();

        // getting addon information in array and storing to public variable
        // addon_name,unique_name,module_id,addon_uri,author,author_uri,version,description,controller_name,installed
        //------------------------------------------------------------------------------------------
        $addon_path=APPPATH."modules/".strtolower($this->router->fetch_class())."/controllers/".ucfirst($this->router->fetch_class()).".php"; // path of addon controller
        $addondata=$this->get_addon_data($addon_path);
        $this->addon_data=$addondata;

        // all addon must be login protected
        //------------------------------------------------------------------------------------------
        if ($this->session->userdata('logged_in')!= 1) redirect('home/login', 'location');          
        // if you want the addon to be accessed by admin and member who has permission to this addon
        //-------------------------------------------------------------------------------------------
        if(isset($addondata['module_id']) && is_numeric($addondata['module_id']) && $addondata['module_id']>0)
        {
            if($this->session->userdata('user_type') != 'Admin' && !in_array($addondata['module_id'],$this->module_access))
            {
                redirect('home/login_page', 'location');
                exit();
            }
        }

        $this->member_validity();
    }

    public function activate()
    {
        $this->ajax_check();

        $addon_controller_name=ucfirst($this->router->fetch_class()); // here addon_controller_name name is Comment [origianl file is Comment.php, put except .php]
        $purchase_code=$this->input->post('purchase_code');
        $this->addon_credential_check($purchase_code,strtolower($addon_controller_name)); // retuns json status,message if error
        
        //this addon system support 2-level sidebar entry, to make sidebar entry you must provide 2D array like below
        $sidebar=array(); 
        // mysql raw query needed to run, it's an array, put each query in a seperate index, create table query must should IF NOT EXISTS
        $sql=
        array
        (
            0 => "CREATE TABLE IF NOT EXISTS `visual_flow_builder_campaign` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `user_id` int(11) NOT NULL,
                  `page_id` int(11) NOT NULL,
                  `unique_id` varchar(50) NOT NULL,
                  `reference_name` text NOT NULL,
                  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
        );
        //send blank array if you does not need sidebar entry,send a blank array if your addon does not need any sql to run
        $this->register_addon($addon_controller_name,$sidebar,$sql,$purchase_code);
    }


    public function deactivate()
    {        
        $this->ajax_check();

        $addon_controller_name=ucfirst($this->router->fetch_class()); // here addon_controller_name name is Comment [origianl file is Comment.php, put except .php]
        // only deletes add_ons,modules and menu, menu_child1 table entires and put install.txt back, it does not delete any files or custom sql
        $this->unregister_addon($addon_controller_name);      
    }

    public function delete()
    {        
        $this->ajax_check();

        $addon_controller_name=ucfirst($this->router->fetch_class()); // here addon_controller_name name is Comment [origianl file is Comment.php, put except .php]

        // mysql raw query needed to run, it's an array, put each query in a seperate index, drop table/column query should have IF EXISTS
        $sql=array
        (       
            0=> "DROP TABLE IF EXISTS `visual_flow_builder_campaign`;"
        );  
        
        // deletes add_ons,modules and menu, menu_child1 table ,custom sql as well as module folder, no need to send sql or send blank array if you does not need any sql to run on delete
        $this->delete_addon($addon_controller_name,$sql);         
    }

    public function index()
    {
        $this->flowbuilder_manager();
    }

    

    public function get_dropdown_postback()
    {
        $this->ajax_check();

        $page_table_id = $this->input->post('page_table_id',true);
        $postback_data=$this->basic->get_data("messenger_bot_postback",array("where"=>array("page_id"=>$page_table_id,"user_id"=>$this->user_id,"is_template"=>"1",'template_for'=>'reply_message')));
        $push_postback="";
        $push_postback.="<option value=''>".$this->lang->line("Select")."</option>";
        foreach ($postback_data as $key => $value) 
        {
            $push_postback.="<option value='".$value['postback_id']."'>".$value['template_name']."</option>";
        }
        $response['dropdown_str'] = $push_postback;
        echo json_encode($response,true);

    }

    public function get_dropdown_otn()
    {
        $this->ajax_check();

        $page_auto_id=$this->input->post('page_table_id',true);// database id

        $postback_id_list = $this->basic->get_data('otn_postback',array('where'=>array('user_id'=>$this->user_id,'page_id'=>$page_auto_id)),array('id','otn_postback_id','template_name'));

        $str='';
        $str .="<option value=''>".$this->lang->line("Select")."</option>";
        if(!empty($postback_id_list))
        {            
            foreach ($postback_id_list as  $value)
            {
                $array_key = $value['id'];
                $array_value = $value['otn_postback_id']." (".$value['template_name'].")";
                $str .="<option value='{$array_key}'>{$array_value}</option>";            

            }
        }

        echo json_encode(array('dropdown_str'=>$str));
    }

    public function get_userinput_flow_list()
    {
        $this->ajax_check();

        $str = '';
        if($this->addon_exist("custom_field_manager"))
        {
            $page_id=$this->input->post('page_table_id',true);// database id

            $table_type = 'user_input_flow_campaign';
            $where_type['where'] = array('user_id'=>$this->user_id,"page_table_id"=>$page_id);
            $info_type = $this->basic->get_data($table_type,$where_type);
            
            $str = '<option value="">'.$this->lang->line('Select Flow campaign').'</option>';
            foreach ($info_type as  $value)
            {
                $id = $value['id'];
                $name = $value['flow_name'];
                $str.=  "<option value='{$id}'>".$name."</option>";            

            }
        }

        echo json_encode(array('dropdown_str'=>$str));
    }

    public function get_label_sequence_dropdown()
    {
        $this->ajax_check();

        $page_id=$this->input->post('page_table_id'); // database id
        $requested_from=$this->input->post('requested_from'); // Request from what?

        $response = [];
        $table_type = 'messenger_bot_broadcast_contact_group';
        $where_type['where'] = array('user_id'=>$this->user_id,"page_id"=>$page_id,"unsubscribe"=>"0","invisible"=>"0");
        $info_type = $this->basic->get_data($table_type,$where_type,$select='', $join='', $limit='', $start='', $order_by='group_name');
        $label_str = '';
        // $label_str = '<option value="0">'.$this->lang->line('Select Labels').'</option>';
        foreach ($info_type as  $value)
        {
            $search_key = $value['id'];
            $search_type = $value['group_name'];
            $label_str .=  "<option value='{$search_key}'>".$search_type."</option>";            
        }
        $response['label_dropdown'] = $label_str;


        $table_type = 'messenger_bot_drip_campaign';
        $where_type['where'] = array('user_id'=>$this->user_id,"page_id"=>$page_id);
        $info_type = $this->basic->get_data($table_type,$where_type,$select='');
        $drip_str = '<option value="">'.$this->lang->line('Select a sequence').'</option>';

        if ('new_postback' == $requested_from) {
            $drip_str .= '<option value="newSequence">'.$this->lang->line('New sequence').'</option>';
        }

        foreach ($info_type as  $value)
        {
            $search_key = $value['id'];
            $search_value = $value['campaign_name'];
            $drip_str .=  "<option value='{$search_key}'>".$search_value."</option>";
        }
        $response['drip_dropdown'] = $drip_str;

        echo json_encode($response,true);
    }

    public function get_store_list()
    {
        $this->ajax_check();

        $page_auto_id=$this->input->post('page_table_id');// database id

        $store_lists = $this->basic->get_data('ecommerce_store',['where'=>['user_id'=>$this->user_id,'page_id'=>$page_auto_id]],['id','store_name','store_city']);

        $str = '';
        $str .= "<option value=''>".$this->lang->line("Select a store")."</option>";
        if(!empty($store_lists))
        {            
            foreach ($store_lists as  $value)
            {
                $array_key = $value['id'];
                $array_value = $value['store_name']." - ".$value['store_city'];
                $str .= "<option value='{$array_key}'>{$array_value}</option>";            

            }
        }

        echo json_encode(array('store_list'=>$str));

    }

    public function get_storewise_products()
    {
        $this->ajax_check();

        $store_id=$this->input->post('selectedStoreId',true);
        $product_lists = $this->basic->get_data('ecommerce_product',['where'=>['user_id'=>$this->user_id,'store_id'=>$store_id]],['id','product_name']);

        $str='';
        // $str .="<option value=''>".$this->lang->line("Select")."</option>";
        if(!empty($product_lists))
        {            
            foreach ($product_lists as  $value)
            {
                $array_key = $value['id'];
                $array_value = $value['product_name'];
                $str .="<option value='{$array_key}'>{$array_value}</option>";            

            }
        }

        echo json_encode(array('product_list'=>$str));
    }


    public function flowbuilder_submit()
    {
        $this->ajax_check();

        $this->load->library('flow_builder');

        $flow_data=$this->input->post('flow_data',true);
        if(!$flow_data){
            echo json_encode(array("status" => "0", "message" =>$this->lang->line("POST data not sent correctly.Try by disabling mod_security for flow builder url.")));
            exit; 
        }

        $builder_table_id=$this->input->post('builder_table_id',true);
        $flow_array = json_decode($flow_data,true);
        $bot_settings_array = $this->flow_builder->extract_json($flow_array);
        
        $reference_name = $bot_settings_array[0]['postback_title'] ?? '';
        $unique_id = $bot_settings_array[0]['xitFbUniqueId'] ?? '';
        $json_data = $flow_data;
        $page_table_id = $this->input->post('page_table_id',true);

        $this->db->trans_start();

        $insert_data = [
                        'user_id' => $this->user_id,
                        'page_id' => $page_table_id,
                        'json_data' => $json_data,
                        'reference_name' => $reference_name,
                        'unique_id' => $unique_id
                    ];
        if($builder_table_id != 0)
        {
            $this->basic->update_data('visual_flow_builder_campaign',['id'=>$builder_table_id,'user_id'=>$this->user_id],$insert_data);
            $visual_flow_campaign_id = $builder_table_id;
            $this->basic->delete_data('messenger_bot',['visual_flow_campaign_id'=>$visual_flow_campaign_id,'user_id'=>$this->user_id,'keyword_type'=>'reply']);
            $this->basic->update_data('messenger_bot',['visual_flow_campaign_id'=>$visual_flow_campaign_id,'user_id'=>$this->user_id,'page_id'=>$page_table_id,'keyword_type !='=>'reply'],['visual_flow_campaign_id'=>0, 'visual_flow_type'=>'general']);

            $this->basic->delete_data('messenger_bot_postback',['visual_flow_campaign_id'=>$visual_flow_campaign_id,'user_id'=>$this->user_id,'template_for'=>'reply_message']);
            $this->basic->update_data('messenger_bot_postback',['visual_flow_campaign_id'=>$visual_flow_campaign_id,'user_id'=>$this->user_id,'page_id'=>$page_table_id,'template_for !='=>'reply_message'], ['visual_flow_campaign_id'=>0, 'visual_flow_type'=>'general']);
        }
        else
        {
            $this->basic->insert_data('visual_flow_builder_campaign',$insert_data);
            $visual_flow_campaign_id = $this->db->insert_id();
        }

        $facebook_rx_fb_page_info = $this->basic->get_data("facebook_rx_fb_page_info",array("where"=>array("id"=>$page_table_id)),array("facebook_rx_fb_user_info_id","page_access_token","page_id"));
        $page_access_token = $facebook_rx_fb_page_info[0]['page_access_token'];
        $facebook_rx_fb_user_info_id = $facebook_rx_fb_page_info[0]["facebook_rx_fb_user_info_id"];
        $white_listed_domain = $this->basic->get_data("messenger_bot_domain_whitelist",array("where"=>array("user_id"=>$this->user_id,"messenger_bot_user_info_id"=>$facebook_rx_fb_user_info_id,"page_id"=>$page_table_id)),"domain");
        $white_listed_domain_array = array();
        foreach ($white_listed_domain as $value) {
            $white_listed_domain_array[] = $value['domain'];
        }
        $need_to_whitelist_array = array();
        $new_sequence_information_array=array();

        foreach ($bot_settings_array as $key => $value) {
            $reply_bot = [];
            $postback_id = $value['postback_id'];
            $postback_title = $value['postback_title'];
            $trigger_keywords = $value['trigger_keywords'] ?? '';
            $sequence_id = $value['sequence_id'] ?? '';
            if(is_array($value['label_ids']))
                $label_ids = implode(',', $value['label_ids']);
            else
                $label_ids = '';


            // keep the new sequence information in another array to process it later after inserting all postbacks . 
            $new_sequence_information= $value['new_sequence_information'] ?? '';
            if($new_sequence_information){
                $new_sequence_information_array[$postback_id]=$new_sequence_information;
            }

            $insert_data = array();
            $insert_data_to_bot = array();
            $insert_data['bot_name'] = $postback_title;
            $insert_data_to_bot['bot_name'] = $postback_title;
            $insert_data['template_name'] = $postback_title;
            $insert_data['postback_id'] = trim($postback_id);
            $insert_data_to_bot['postback_id'] = trim($postback_id);
            $insert_data['page_id'] = $page_table_id;
            $insert_data_to_bot['page_id'] = $page_table_id;
            $insert_data['is_template'] = '1';
            $insert_data_to_bot['is_template'] = '1';
            $insert_data['use_status'] = '1';
            $insert_data["broadcaster_labels"]=$label_ids;
            $insert_data_to_bot["broadcaster_labels"]=$label_ids;
            $insert_data["drip_campaign_id"]=$sequence_id;
            $insert_data_to_bot["drip_campaign_id"]=$sequence_id;
            $insert_data_to_bot['fb_page_id'] = $facebook_rx_fb_page_info[0]['page_id'];
            $insert_data['user_id'] = $this->user_id;        
            $insert_data_to_bot['user_id'] = $this->user_id;

            $insert_data['visual_flow_type'] = 'flow';
            $insert_data['visual_flow_campaign_id'] = $visual_flow_campaign_id;
            $insert_data_to_bot['visual_flow_type'] = 'flow';
            $insert_data_to_bot['visual_flow_campaign_id'] = $visual_flow_campaign_id;

            if(isset($value['reply']))
            foreach ($value['reply'] as $single_reply_key => $single_reply_value) 
            {

                if($single_reply_value['is_typing_display'] == 'true') 
                    $reply_bot[$single_reply_key]['typing_on_settings'] = 'on';
                else 
                    $reply_bot[$single_reply_key]['typing_on_settings'] = 'off';

                if($single_reply_value['delay_time'] != '')
                    $reply_bot[$single_reply_key]['delay_in_reply'] = $single_reply_value['delay_time'];
                else
                    $reply_bot[$single_reply_key]['delay_in_reply'] = 0;

                if($single_reply_value['reply_type'] == 'textInput')
                {
                    if(!empty($single_reply_value['buttons']))
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'text_with_buttons';
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'template';
                        $reply_bot[$single_reply_key]['attachment']['payload']['template_type'] = 'button';
                        $reply_bot[$single_reply_key]['attachment']['payload']['text'] = $single_reply_value['reply_text'] ?? '';
                        
                        foreach($single_reply_value['buttons'] as $single_button_key => $single_button_info)
                        {
                            $button_text = $single_button_info['button_text'] ?? '';

                            if($single_button_info['button_type'] == 'post_back' || $single_button_info['button_type'] == 'new_post_back')
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['type'] = 'postback';
                                $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['payload'] = $single_button_info['value'] ?? '';
                                $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['title'] = $button_text;
                            }
                            else if($single_button_info['button_type'] == 'phone_number')
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['type'] = 'phone_number';
                                $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['payload'] = $single_button_info['value'] ?? '';
                                $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['title'] = $button_text;
                            }
                            else if(strpos($single_button_info['button_type'],'web_url') !== FALSE)
                            {
                                if($single_button_info['value']!='')
                                    $button_web_url=add_query_string_to_url($single_button_info['value'],"subscriber_id","#SUBSCRIBER_ID_REPLACE#");
                                else
                                    $button_web_url = '';

                                $button_type_array = explode('_', $single_button_info['button_type']);
                                if(isset($button_type_array[2]))
                                {
                                    $button_extension = trim($button_type_array[2],'_'); 
                                    array_pop($button_type_array);
                                }            
                                else $button_extension = '';
                                $button_type = implode('_', $button_type_array);

                                if($button_text != '' && $button_type != '' && ($button_web_url != '' || $button_extension != ''))
                                {
                                    $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['type'] = 'web_url';

                                    if($button_extension != '' && $button_extension == 'birthday'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['url'] = base_url('webview_builder/get_birthdate?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_birthdate');
                                    }
                                    else if($button_extension != '' && $button_extension == 'email'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['url'] = base_url('webview_builder/get_email?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_email');
                                    }
                                    else if($button_extension != '' && $button_extension == 'phone'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['url'] = base_url('webview_builder/get_phone?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_phone');
                                    }
                                    else if($button_extension != '' && $button_extension == 'location'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['url'] = base_url('webview_builder/get_location?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_location');
                                    }
                                    else
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['url'] = $button_web_url;
                                    $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['title'] = $button_text;

                                    if($button_extension != '' && $button_extension != 'birthday' && $button_extension !="email" && $button_extension !="phone" && $button_extension !="location")
                                    {
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['buttons'][$single_button_key]['webview_height_ratio'] = $button_extension;
                                    }

                                    if(!in_array($button_web_url, $white_listed_domain_array))
                                    {
                                        $need_to_whitelist_array[] = $button_web_url;
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'text';
                        $reply_bot[$single_reply_key]['text'] = $single_reply_value['reply_text'] ?? '';
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }

                }

                else if($single_reply_value['reply_type'] == 'imageInput')
                {
                    $image_url = $single_reply_value['url'] ?? '';
                    if($image_url != '')
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'image';
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'image';
                        $reply_bot[$single_reply_key]['attachment']['payload']['url'] = $image_url;
                        $reply_bot[$single_reply_key]['attachment']['payload']['is_reusable'] = true;                    
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }
                }

                else if($single_reply_value['reply_type'] == 'audioInput')
                {
                    $audio_file_url = $single_reply_value['url'] ?? '';
                    if($audio_file_url != '')
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'audio';
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'audio';
                        $reply_bot[$single_reply_key]['attachment']['payload']['url'] = $audio_file_url;
                        $reply_bot[$single_reply_key]['attachment']['payload']['is_reusable'] = true;
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }
                    
                }

                else if($single_reply_value['reply_type'] == 'videoInput')
                {
                    $video_file_url = $single_reply_value['url'] ?? '';
                    if($video_file_url != '')
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'video';
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'video';
                        $reply_bot[$single_reply_key]['attachment']['payload']['url'] = $video_file_url;
                        $reply_bot[$single_reply_key]['attachment']['payload']['is_reusable'] = true;                    
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }
                }

                else if($single_reply_value['reply_type'] == 'fileInput')
                {
                    $file_type_url = $single_reply_value['url'] ?? '';
                    if($file_type_url != '')
                    {       
                        $reply_bot[$single_reply_key]['template_type'] = 'file';             
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'file';
                        $reply_bot[$single_reply_key]['attachment']['payload']['url'] = $file_type_url;
                        $reply_bot[$single_reply_key]['attachment']['payload']['is_reusable'] = true;
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }
                }

                else if($single_reply_value['reply_type'] == 'otnInput')
                {
                    $otn_title = $single_reply_value['reply_text'];
                    $otn_postback = $single_reply_value['otn_postback_id'];
                    if($otn_title != '' && $otn_postback != '')
                    {       
                        $reply_bot[$single_reply_key]['template_type'] = 'One_Time_Notification';             
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'template';
                        $reply_bot[$single_reply_key]['attachment']['payload']['template_type'] = "one_time_notif_req";
                        $reply_bot[$single_reply_key]['attachment']['payload']['title'] = $otn_title;
                        $reply_bot[$single_reply_key]['attachment']['payload']['payload'] = $otn_postback;
                    }
                }

                else if($single_reply_value['reply_type'] == 'facebookMediaInput')
                {
                    $media_input = $single_reply_value['media_url'];
                    if($media_input != '')
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'media';
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'template';
                        $reply_bot[$single_reply_key]['attachment']['payload']['template_type'] = 'media';
                        $template_media_type = '';
                        if (strpos($media_input, '/videos/') !== false) {
                            $template_media_type = 'video';
                        }
                        else
                            $template_media_type = 'image';
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['media_type'] = $template_media_type;
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['url'] = $media_input;                    
                    }

                    foreach ($single_reply_value['buttons'] as $media_reply_button_key => $media_reply_button_info)
                    { 
                        $button_text = $media_reply_button_info['button_text'] ?? '';
                        $button_type = $media_reply_button_info['button_type'] ?? '';

                        if($button_type == 'post_back' || $button_type == 'new_post_back')
                        {
                            $button_postback_id = $media_reply_button_info['value'] ?? '';
                            if($button_text != '' && $button_type != '' && $button_postback_id != '')
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['type'] = 'postback';
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['payload'] = $button_postback_id;
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['title'] = $button_text;
                            }
                        }
                        if(strpos($button_type,'web_url') !== FALSE)
                        {
                            $button_web_url = $media_reply_button_info['value'] ?? '';
                            //add an extra query parameter for tracking the subscriber to whom send 
                            if($button_web_url!='')
                                $button_web_url=add_query_string_to_url($button_web_url,"subscriber_id","#SUBSCRIBER_ID_REPLACE#");

                            $button_type_array = explode('_', $button_type);
                            if(isset($button_type_array[2]))
                            {
                                $button_extension = trim($button_type_array[2],'_'); 
                                array_pop($button_type_array);
                            }            
                            else $button_extension = '';
                            $button_type = implode('_', $button_type_array);

                            if($button_text != '' && $button_type != '' && ($button_web_url != '' || $button_extension != ''))
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['type'] = 'web_url';
                                if($button_extension != '' && $button_extension == 'birthday'){
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['url'] = base_url('webview_builder/get_birthdate?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_birthdate');
                                }
                                else if($button_extension != '' && $button_extension == 'email'){
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['url'] = base_url('webview_builder/get_email?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_email');
                                }
                                else if($button_extension != '' && $button_extension == 'phone'){
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['url'] = base_url('webview_builder/get_phone?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_phone');
                                }
                                else if($button_extension != '' && $button_extension == 'location'){
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['url'] = base_url('webview_builder/get_location?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_location');
                                }
                                else
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['url'] = $button_web_url;
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['title'] = $button_text;

                                if($button_extension != '' && $button_extension != 'birthday' && $button_extension !="email" && $button_extension !="phone" && $button_extension !="location")
                                {
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['webview_height_ratio'] = $button_extension;
                                }
                            }
                        }
                        if($button_type == 'phone_number')
                        {
                            $button_call_us = $media_reply_button_info['value'] ?? '';
                            if($button_text != '' && $button_type != '' && $button_call_us != '')
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['type'] = 'phone_number';
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['payload'] = $button_call_us;
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$media_reply_button_key]['title'] = $button_text;
                            }
                        }
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }
                }

                else if($single_reply_value['reply_type'] == 'genericTemplateInput')
                {
                    $generic_template_title = $single_reply_value['generic_template']['carousel_item_title'] ?? '';
                    $generic_template_subtitle = $single_reply_value['generic_template']['carousel_item_sub_title'] ?? '';
                    $generic_template_image = $single_reply_value['generic_template']['image_url'] ?? '';
                    $generic_template_image_destination_link = $single_reply_value['generic_template']['carousel_item_image_destination'] ?? '';

                    if($generic_template_title != '')
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'generic_template';
                        $reply_bot[$single_reply_key]['attachment']['type'] = 'template';
                        $reply_bot[$single_reply_key]['attachment']['payload']['template_type'] = 'generic';
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['title'] = $generic_template_title;                   
                    }

                    if($generic_template_subtitle != '')
                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['subtitle'] = $generic_template_subtitle;

                    if($generic_template_image!="")
                    {
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['image_url'] =$generic_template_image;
                        if($generic_template_image_destination_link!="")
                        {
                            $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['default_action']['type'] = 'web_url';
                            $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['default_action']['url'] = $generic_template_image_destination_link;
                        }

                        // if(function_exists('getimagesize') && $generic_template_image!='') 
                        // {
                        //     $full_generic_template_image = base_url().$generic_template_image;
                        //     list($width, $height, $type, $attr) = getimagesize($full_generic_template_image);
                        //     if($width==$height)
                        //         $reply_bot[$single_reply_key]['attachment']['payload']['image_aspect_ratio'] = 'square';
                        // }
                        $reply_bot[$single_reply_key]['attachment']['payload']['image_aspect_ratio'] = 'square';

                    }
                    

                    foreach ($single_reply_value['buttons'] as $generic_button_index => $generic_button_info)
                    { 
                        $button_type = $generic_button_info['button_type'] ?? '';
                        $button_text = $generic_button_info['button_text'] ?? '';
                        
                        if($button_type == 'post_back' || $button_type == 'new_post_back')
                        {
                            $button_postback_id = $generic_button_info['value'] ?? '';
                            if($button_text != '' && $button_type != '' && $button_postback_id != '')
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['type'] = 'postback';
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['payload'] = $button_postback_id;
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['title'] = $button_text;
                            }
                        }
                        if(strpos($button_type,'web_url') !== FALSE)
                        {
                            $button_web_url = $generic_button_info['value'] ?? '';
                            //add an extra query parameter for tracking the subscriber to whom send 
                            if($button_web_url!='')
                                $button_web_url=add_query_string_to_url($button_web_url,"subscriber_id","#SUBSCRIBER_ID_REPLACE#");

                            $button_type_array = explode('_', $button_type);
                            if(isset($button_type_array[2]))
                            {
                                $button_extension = trim($button_type_array[2],'_'); 
                                array_pop($button_type_array);
                            }            
                            else $button_extension = '';
                            $button_type = implode('_', $button_type_array);

                            if($button_text != '' && $button_type != '' && ($button_web_url != '' || $button_extension != ''))
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['type'] = 'web_url';
                                if($button_extension != '' && $button_extension == 'birthday'){                                
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['url'] = base_url('webview_builder/get_birthdate?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_birthdate');
                                }
                                else if($button_extension != '' && $button_extension == 'email'){                                
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['url'] = base_url('webview_builder/get_email?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_email');
                                }
                                else if($button_extension != '' && $button_extension == 'phone'){                                
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['url'] = base_url('webview_builder/get_phone?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_phone');
                                }
                                else if($button_extension != '' && $button_extension == 'location'){                                
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['webview_height_ratio'] = 'full';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['url'] = base_url('webview_builder/get_location?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                    $button_web_url = base_url('webview_builder/get_location');
                                }
                                else
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['url'] = $button_web_url;
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['title'] = $button_text;

                                if($button_extension != '' && $button_extension != 'birthday' && $button_extension !="email" && $button_extension !="phone" && $button_extension !="location")
                                {
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['messenger_extensions'] = 'true';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['webview_height_ratio'] = $button_extension;
                                }

                                if(!in_array($button_web_url, $white_listed_domain_array))
                                {
                                    $need_to_whitelist_array[] = $button_web_url;
                                }

                            }
                        }
                        if($button_type == 'phone_number')
                        {
                            $button_call_us = $generic_button_info['value'] ?? '';
                            if($button_text != '' && $button_type != '' && $button_call_us != '')
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['type'] = 'phone_number';
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['payload'] = $button_call_us;
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][0]['buttons'][$generic_button_index]['title'] = $button_text;
                            }
                        }
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }

                }

                else if($single_reply_value['reply_type'] == 'carouselInput')
                {
                    $reply_bot[$single_reply_key]['template_type'] = 'carousel';
                    $reply_bot[$single_reply_key]['attachment']['type'] = 'template';
                    $reply_bot[$single_reply_key]['attachment']['payload']['template_type'] = 'generic';


                    foreach ($single_reply_value['carousel_items'] as $carousel_item_index => $carousel_item_info) 
                    {   
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['title'] = $carousel_item_info['carousel_item_title'];
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['subtitle'] = $carousel_item_info['carousel_item_sub_title'];
                        $carousel_image = $carousel_item_info['image_url'] ?? '';

                        if(isset($carousel_image) && $carousel_image!="")
                        {
                            $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['image_url'] = $carousel_image;                    
                            $carousel_image_destination_link = $carousel_item_info['carousel_item_image_destination'] ?? '';
                            if($carousel_image_destination_link!="") 
                            {
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['default_action']['type'] = 'web_url';
                                $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['default_action']['url'] = $carousel_image_destination_link;
                            }

                            // if(function_exists('getimagesize') && $carousel_image!='') 
                            // {
                            //     $full_carousel_image = base_url().$carousel_image;
                            //     list($width, $height, $type, $attr) = getimagesize($full_carousel_image);
                            //     if($width==$height)
                            //         $reply_bot[$single_reply_key]['attachment']['payload']['image_aspect_ratio'] = 'square';
                            // }
                            $reply_bot[$single_reply_key]['attachment']['payload']['image_aspect_ratio'] = 'square';

                        }
                        
                        foreach ($carousel_item_info['button_info'] as $carousel_item_button_index => $carousel_item_button_info)
                        { 
                            $button_type = $carousel_item_button_info['button_type'];
                            $button_text = $carousel_item_button_info['button_text'];
                            
                            if($button_type == 'post_back' || $button_type == 'new_post_back')
                            {
                                $button_postback_id = $carousel_item_button_info['value'] ?? '';
                                if($button_text != '' && $button_type != '' && $button_postback_id != '')
                                {
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['type'] = 'postback';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['payload'] = $button_postback_id;
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['title'] = $button_text;
                                }
                            }

                            if(strpos($button_type,'web_url') !== FALSE)
                            {
                                $button_web_url = $carousel_item_button_info['value'] ?? '';
                                //add an extra query parameter for tracking the subscriber to whom send 
                                if($button_web_url!='')
                                  $button_web_url=add_query_string_to_url($button_web_url,"subscriber_id","#SUBSCRIBER_ID_REPLACE#");

                                $button_type_array = explode('_', $button_type);
                                if(isset($button_type_array[2]))
                                {
                                    $button_extension = trim($button_type_array[2],'_'); 
                                    array_pop($button_type_array);
                                }            
                                else $button_extension = '';
                                $button_type = implode('_', $button_type_array);

                                if($button_text != '' && $button_type != '' && ($button_web_url != '' || $button_extension != ''))
                                {
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['type'] = 'web_url';
                                    if($button_extension != '' && $button_extension == 'birthday'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['url'] = base_url('webview_builder/get_birthdate?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_birthdate');
                                    }
                                    else if($button_extension != '' && $button_extension == 'email'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['url'] = base_url('webview_builder/get_email?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_email');
                                    }
                                    else if($button_extension != '' && $button_extension == 'phone'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['url'] = base_url('webview_builder/get_phone?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_phone');
                                    }
                                    else if($button_extension != '' && $button_extension == 'location'){
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['webview_height_ratio'] = 'full';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['url'] = base_url('webview_builder/get_location?subscriber_id=#SUBSCRIBER_ID_REPLACE#');
                                        $button_web_url = base_url('webview_builder/get_location');
                                    }
                                    else
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['url'] = $button_web_url;
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['title'] = $button_text;

                                    if($button_extension != '' && $button_extension != 'birthday' && $button_extension !="email" && $button_extension !="phone" && $button_extension !="location")
                                    {
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['messenger_extensions'] = 'true';
                                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['webview_height_ratio'] = $button_extension;
                                    }

                                    if(!in_array($button_web_url, $white_listed_domain_array))
                                    {
                                        $need_to_whitelist_array[] = $button_web_url;
                                    }

                                }
                            }

                            if($button_type == 'phone_number')
                            {
                                $button_call_us = $carousel_item_button_info['value'] ?? '';

                                if($button_text != '' && $button_type != '' && $button_call_us != '')
                                {
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['type'] = 'phone_number';
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['payload'] = $button_call_us;
                                    $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$carousel_item_index]['buttons'][$carousel_item_button_index]['title'] = $button_text;
                                }
                            }
                        }

                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }

                }

                else if($single_reply_value['reply_type'] == 'ecommerceInput')
                {
                    $this->load->helper('ecommerce_helper');
                    $currency_icons = $this->currency_icon();

                    $reply_bot[$single_reply_key]['template_type'] = 'Ecommerce';
                    $reply_bot[$single_reply_key]['attachment']['type'] = 'template';
                    $reply_bot[$single_reply_key]['attachment']['payload']['template_type'] = 'generic';

                    $buy_now_text = $single_reply_value['buy_now_button_text'];
                    $products_array = $single_reply_value['product_ids'];

                    foreach($products_array as $index_variable => $product_id)
                    {
                        $product_data = $this->basic->get_data('ecommerce_product',['where'=>['id'=>$product_id,'user_id'=>$this->user_id]],['store_id','product_name','original_price','sell_price','thumbnail','id','woocommerce_product_id']);
                        if(!isset($product_data[0])) continue;
                        $store_id = isset($product_data[0]['store_id']) ? $product_data[0]['store_id'] : 0;
                        $ecommerce_config = $this->basic->get_data('ecommerce_config',['where'=>['user_id'=>$this->user_id,'store_id'=>$store_id]],['currency','currency_position','decimal_point','thousand_comma']);

                        $original_price = isset($product_data[0]['original_price']) ? $product_data[0]['original_price'] : 0;
                        $sell_price = isset($product_data[0]['sell_price']) ? $product_data[0]['sell_price'] : 0;
                        $currency_position = isset($ecommerce_config[0]['currency_position']) ? $ecommerce_config[0]['currency_position'] : 'left';
                        $decimal_point = isset($ecommerce_config[0]['decimal_point']) ? $ecommerce_config[0]['decimal_point'] : 0;
                        $thousand_comma = isset($ecommerce_config[0]['thousand_comma']) ? $ecommerce_config[0]['thousand_comma'] : 0;
                        $currency_icon = '$';
                        if(isset($ecommerce_config[0]['currency']))
                        {
                            $currency_icon = isset($currency_icons[$ecommerce_config[0]['currency']]) ? $currency_icons[$ecommerce_config[0]['currency']] : '$';
                        }
                        $subtitle = mec_display_price($original_price,$sell_price,$currency_icon,'2',$currency_position,$decimal_point,$thousand_comma);
                        if($currency_position == 'left') $subtitle = $currency_icon.$subtitle;
                        else $subtitle = $subtitle.$currency_icon;
                        $title = isset($product_data[0]['product_name']) ? $product_data[0]['product_name'] : '';


                        $thumbnail = ($product_data[0]['thumbnail']!='') ? base_url('upload/ecommerce/'.$product_data[0]['thumbnail']) : base_url('assets/img/products/product-1.jpg');
                        if(isset($product_data[0]["woocommerce_product_id"]) && !is_null($product_data[0]["woocommerce_product_id"]) && $product_data[0]['thumbnail']!='')
                        $thumbnail = $product_data[0]['thumbnail'];


                        // if(function_exists('getimagesize') && $thumbnail!='') 
                        // {
                        //     list($width, $height, $type, $attr) = getimagesize($thumbnail);
                        //     if($width==$height)
                        //         $reply_bot[$single_reply_key]['attachment']['payload']['image_aspect_ratio'] = 'square';
                        // }
                        $reply_bot[$single_reply_key]['attachment']['payload']['image_aspect_ratio'] = 'square';
                        $buy_now_url = base_url('ecommerce/product/').$product_id;
                        $buy_now_url = add_query_string_to_url($buy_now_url,"subscriber_id","#SUBSCRIBER_ID_REPLACE#");

                        if(!in_array($buy_now_url, $white_listed_domain_array))
                        {
                            $need_to_whitelist_array[] = $buy_now_url;
                        }

                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['title'] = $title;
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['subtitle'] = $subtitle;
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['image_url'] = $thumbnail;
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['default_action']['type'] = 'web_url';
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['default_action']['url'] = $buy_now_url;

                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['buttons'][$index_variable]['type'] = 'web_url';
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['buttons'][$index_variable]['messenger_extensions'] = 'true';
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['buttons'][$index_variable]['webview_height_ratio'] = 'full';
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['buttons'][$index_variable]['url'] = $buy_now_url;
                        $reply_bot[$single_reply_key]['attachment']['payload']['elements'][$index_variable]['buttons'][$index_variable]['title'] = $buy_now_text;
                    }

                    if(!empty($single_reply_value['quick_replies']))
                    {
                        $quick_replies = $this->generate_quick_replies($single_reply_value['quick_replies']);
                        $reply_bot[$single_reply_key]['quick_replies'] = $quick_replies;
                    }
                }

                else if($single_reply_value['reply_type'] == 'userInputFlowInput')
                {
                    $flow_campaign_id = $single_reply_value['user_input_flow_id'] ?? '';
                    if($flow_campaign_id != '')
                    {
                        $reply_bot[$single_reply_key]['template_type'] = 'User_Input_Flow';
                        $reply_bot[$single_reply_key]['flow_campaign_id'] = $flow_campaign_id;
                        
                    }
                }

            }


            $reply_bot_filtered = array();
            $m=0;
            foreach ($reply_bot as $value2) {
                $m++;
                $reply_bot_filtered[$m]['recipient'] = array('id'=>'replace_id');
                $reply_bot_filtered[$m]['message'] = $value2;
            }

            $insert_data['template_jsoncode'] = json_encode($reply_bot_filtered,true);
            $insert_data_to_bot['message'] = json_encode($reply_bot_filtered,true);

            
            $this->basic->insert_data('messenger_bot',$insert_data_to_bot);
            $messenger_bot_table_id = $this->db->insert_id();
            $messenger_bot_table_id_info[$insert_data['postback_id']]= $messenger_bot_table_id;

            $insert_data['messenger_bot_table_id'] = $messenger_bot_table_id;
            $this->basic->insert_data('messenger_bot_postback',$insert_data);
            $postback_id_table_id_info[$insert_data['postback_id']]= $this->db->insert_id();

            if($trigger_keywords != '')
            {
                $insert_data_to_bot['is_template'] = '0';
                $insert_data_to_bot['keywords'] = $trigger_keywords;
                $this->basic->insert_data('messenger_bot',$insert_data_to_bot);
            }


            $action_button_type = $value['action_button_type'] ?? '';
            if($action_button_type)
            {
                $insert_template = $this->return_static_array();
                $insert_data_to_bot['postback_id'] = $insert_template[$action_button_type]['postback_id'];
                $insert_data_to_bot['bot_name'] = $insert_template[$action_button_type]['bot_name'];
                $insert_data_to_bot['keyword_type'] = $insert_template[$action_button_type]['keyword_type'];
                $insert_data_to_bot['is_template'] = '0';
                unset($insert_data_to_bot['keywords']);

                $insert_data['bot_name'] = $insert_template[$action_button_type]['bot_name'];
                $insert_data['template_name'] = $insert_template[$action_button_type]['bot_name'];
                $insert_data['postback_id'] = $insert_template[$action_button_type]['postback_id'];
                $insert_data['use_status'] = '0';

                if($action_button_type == 'get-started' || $action_button_type == 'no match')
                {
                    $this->basic->delete_data('messenger_bot',['user_id'=>$this->user_id,'page_id'=>$insert_data_to_bot['page_id'],'keyword_type'=>$insert_data_to_bot['keyword_type']]);
                    $this->basic->insert_data('messenger_bot',$insert_data_to_bot);
                }
                else
                {
                    $insert_data['template_for'] = $insert_template[$action_button_type]['template_for'];

                    $this->basic->delete_data('messenger_bot',['user_id'=>$this->user_id,'page_id'=>$insert_data_to_bot['page_id'],'keyword_type'=>$insert_data_to_bot['keyword_type']]);
                    $this->basic->delete_data('messenger_bot_postback',['user_id'=>$this->user_id,'page_id'=>$insert_data['page_id'],'template_for'=>$insert_data['template_for']]);

                    $this->basic->insert_data('messenger_bot',$insert_data_to_bot);
                    $messenger_bot_table_id = $this->db->insert_id();

                    $insert_data['messenger_bot_table_id'] = $messenger_bot_table_id;
                    $this->basic->insert_data('messenger_bot_postback',$insert_data);
                }
            }

        }


        // Process new Messenger Sequence Campaign 
        foreach($new_sequence_information_array as $key_postback=>$new_sequence_campaign){

            $insert_info['campaign_name']= $new_sequence_campaign['name'] ?? "" ;
            $insert_info['between_start']= $new_sequence_campaign['startingTime'] ?? "";
            $insert_info['between_end']= $new_sequence_campaign['closingTime'] ?? "";
            $insert_info['timezone']= $new_sequence_campaign['timezone'] ?? "";
            $insert_info['message_tag']= $new_sequence_campaign['messageTag'] ?? "";
            $insert_info['page_id']= $page_table_id;
            $insert_info['user_id']= $this->user_id;  
            $insert_info['created_at']= date("Y-m-d H:i:s");
            $insert_info['drip_type']= "custom";
            $insert_info['campaign_type']= "messenger";
            $insert_info['visual_flow_campaign_id']= $visual_flow_campaign_id;
            $insert_info['visual_flow_sequence_id']= $new_sequence_campaign['xitFbUniqueSequenceId'];


            $promotional_campaing= $new_sequence_campaign['promotional'] ?? array();

            $promotional_campaing_data_array=array();

            foreach($promotional_campaing as $promotional_campaing_single){
                $promotional_campaing_data_array[$promotional_campaing_single['time']] = $postback_id_table_id_info[$promotional_campaing_single['postback_id']];
            }


            $non_promotional_campaing= $new_sequence_campaign['non_promotional'] ?? array();

            $non_promotional_campaing_data_array=array();

            foreach($non_promotional_campaing as $non_promotional_campaing_single){
                $non_promotional_campaing_data_array[$non_promotional_campaing_single['time']] = $postback_id_table_id_info[$non_promotional_campaing_single['postback_id']];
            }

            $insert_info['message_content_hourly']= json_encode($promotional_campaing_data_array);
            $insert_info['message_content']= json_encode($non_promotional_campaing_data_array);

            $where_array['where']=array('visual_flow_sequence_id'=>$new_sequence_campaign['xitFbUniqueSequenceId'],'page_id'=>$page_table_id);
            $sequence_exist= $this->basic->get_data('messenger_bot_drip_campaign',$where_array,'id');

            if(empty($sequence_exist)){
                $this->basic->insert_data('messenger_bot_drip_campaign',$insert_info);
                $new_sequence_id=$this->db->insert_id();
            }
            else{
                $update_data_new_sequence=array("message_content"=>$insert_info['message_content'],"message_content_hourly"=>$insert_info['message_content_hourly']);
                $new_sequence_id=$sequence_exist[0]['id'] ?? "";
                $this->basic->update_data('messenger_bot_drip_campaign',array("id"=>$new_sequence_id),$update_data_new_sequence);                
            }

            // Update the main postback where this squence need to be assaigned. 
            $postback_table_id= $postback_id_table_id_info[$key_postback];
            $messenger_bot_table_id= $messenger_bot_table_id_info[$key_postback];

            $this->basic->update_data('messenger_bot_postback',array("id"=>$postback_table_id),array("drip_campaign_id"=>$new_sequence_id));    
            $this->basic->update_data('messenger_bot',array("id"=>$messenger_bot_table_id),array("drip_campaign_id"=>$new_sequence_id));    


          

        }


        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
            echo json_encode(array("status" => "0", "message" =>$this->lang->line("Creating template was unsuccessful. Database error occured during creating template.")));
        else
        {
            // domain white list section start
            $this->load->library("fb_rx_login"); 
            $domain_whitelist_insert_data = array();
            foreach($need_to_whitelist_array as $value)
            {
                $domain_only_whitelist= get_domain_only_with_http($value);
                if(in_array($domain_only_whitelist, $white_listed_domain_array)) continue; 

                $response=$this->fb_rx_login->domain_whitelist($page_access_token,$domain_only_whitelist);
                if($response['status'] != '0')
                {
                    $temp_data = array();
                    $temp_data['user_id'] = $this->user_id;
                    $temp_data['messenger_bot_user_info_id'] = $facebook_rx_fb_user_info_id;
                    $temp_data['page_id'] = $page_table_id;
                    $temp_data['domain'] = $domain_only_whitelist;
                    $temp_data['created_at'] = date("Y-m-d H:i:s");
                    $domain_whitelist_insert_data[] = $temp_data;
                }
            }
            if(!empty($domain_whitelist_insert_data))
                $this->db->insert_batch('messenger_bot_domain_whitelist',$domain_whitelist_insert_data);
            // domain white list section end
            
            if($builder_table_id != 0)
                echo json_encode(array("status" => "1", "message" =>$this->lang->line("Template has been updated successfully.")));
            else
                echo json_encode(array("status" => "1", "message" =>$this->lang->line("New template has been stored successfully.")));
        }
    }


    public function return_static_array()
    {
        $insert_template['UNSUBSCRIBE_QUICK_BOXER']['postback_id'] = 'UNSUBSCRIBE_QUICK_BOXER';
        $insert_template['UNSUBSCRIBE_QUICK_BOXER']['bot_name'] = 'UNSUBSCRIBE BOT';
        $insert_template['UNSUBSCRIBE_QUICK_BOXER']['keyword_type'] = 'post-back';
        $insert_template['UNSUBSCRIBE_QUICK_BOXER']['template_for'] = 'unsubscribe';

        $insert_template['RESUBSCRIBE_QUICK_BOXER']['postback_id'] = 'RESUBSCRIBE_QUICK_BOXER';
        $insert_template['RESUBSCRIBE_QUICK_BOXER']['bot_name'] = 'RESUBSCRIBE BOT';
        $insert_template['RESUBSCRIBE_QUICK_BOXER']['keyword_type'] = 'post-back';
        $insert_template['RESUBSCRIBE_QUICK_BOXER']['template_for'] = 'resubscribe';

        $insert_template['YES_START_CHAT_WITH_BOT']['postback_id'] = 'YES_START_CHAT_WITH_BOT';
        $insert_template['YES_START_CHAT_WITH_BOT']['bot_name'] = 'CHAT WITH BOT';
        $insert_template['YES_START_CHAT_WITH_BOT']['keyword_type'] = 'post-back';
        $insert_template['YES_START_CHAT_WITH_BOT']['template_for'] = 'chat-with-bot';

        $insert_template['YES_START_CHAT_WITH_HUMAN']['postback_id'] = 'YES_START_CHAT_WITH_HUMAN';
        $insert_template['YES_START_CHAT_WITH_HUMAN']['bot_name'] = 'CHAT WITH HUMAN';
        $insert_template['YES_START_CHAT_WITH_HUMAN']['keyword_type'] = 'post-back';
        $insert_template['YES_START_CHAT_WITH_HUMAN']['template_for'] = 'chat-with-human';

        $insert_template['QUICK_REPLY_BIRTHDAY_REPLY_BOT']['postback_id'] = 'QUICK_REPLY_BIRTHDAY_REPLY_BOT';
        $insert_template['QUICK_REPLY_BIRTHDAY_REPLY_BOT']['bot_name'] = 'QUICK REPLY BIRTHDAY REPLY';
        $insert_template['QUICK_REPLY_BIRTHDAY_REPLY_BOT']['keyword_type'] = 'birthday-quick-reply';
        $insert_template['QUICK_REPLY_BIRTHDAY_REPLY_BOT']['template_for'] = 'birthday-quick-reply';

        $insert_template['QUICK_REPLY_LOCATION_REPLY_BOT']['postback_id'] = 'QUICK_REPLY_LOCATION_REPLY_BOT';
        $insert_template['QUICK_REPLY_LOCATION_REPLY_BOT']['bot_name'] = 'QUICK REPLY LOCATION REPLY';
        $insert_template['QUICK_REPLY_LOCATION_REPLY_BOT']['keyword_type'] = 'location-quick-reply';
        $insert_template['QUICK_REPLY_LOCATION_REPLY_BOT']['template_for'] = 'location-quick-reply';

        $insert_template['QUICK_REPLY_PHONE_REPLY_BOT']['postback_id'] = 'QUICK_REPLY_PHONE_REPLY_BOT';
        $insert_template['QUICK_REPLY_PHONE_REPLY_BOT']['bot_name'] = 'QUICK REPLY PHONE REPLY';
        $insert_template['QUICK_REPLY_PHONE_REPLY_BOT']['keyword_type'] = 'phone-quick-reply';
        $insert_template['QUICK_REPLY_PHONE_REPLY_BOT']['template_for'] = 'phone-quick-reply';

        $insert_template['QUICK_REPLY_EMAIL_REPLY_BOT']['postback_id'] = 'QUICK_REPLY_EMAIL_REPLY_BOT';
        $insert_template['QUICK_REPLY_EMAIL_REPLY_BOT']['bot_name'] = 'QUICK REPLY EMAIL REPLY';
        $insert_template['QUICK_REPLY_EMAIL_REPLY_BOT']['keyword_type'] = 'email-quick-reply';
        $insert_template['QUICK_REPLY_EMAIL_REPLY_BOT']['template_for'] = 'email-quick-reply';

        $insert_template['get-started']['postback_id'] = '';
        $insert_template['get-started']['bot_name'] = 'GET STARTED';
        $insert_template['get-started']['keyword_type'] = 'get-started';
        $insert_template['get-started']['template_for'] = '';

        $insert_template['no match']['postback_id'] = '';
        $insert_template['no match']['bot_name'] = 'NO MATCH FOUND';
        $insert_template['no match']['keyword_type'] = 'no match';
        $insert_template['no match']['template_for'] = '';
        return $insert_template;
    }


    public function generate_quick_replies($quick_replies_array=[])
    {
        $reply_bot = [];
        foreach($quick_replies_array as $quick_reply_key => $quick_reply_info)
        { 
            $button_text = $quick_reply_info['button_text'] ?? '';
            $button_type = $quick_reply_info['button_type'] ?? '';

            if($button_type=='postback' || $button_type=='newPostback')
            {
                $button_postback_id = $quick_reply_info['value'] ?? '';
                if($button_text != '' && $button_postback_id != '')
                {
                    $reply_bot[$quick_reply_key]['content_type'] = 'text';
                    $reply_bot[$quick_reply_key]['payload'] = $button_postback_id;
                    $reply_bot[$quick_reply_key]['title'] = $button_text; 
                }                    
            }
            if($button_type=='phone')
            {
                $reply_bot[$quick_reply_key]['content_type'] = 'user_phone_number';
            }
            if($button_type=='email')
            {
                $reply_bot[$quick_reply_key]['content_type'] = 'user_email';
            }
            if($button_type=='location')
            {
                $reply_bot[$quick_reply_key]['content_type'] = 'location';
            }

        }
        return $reply_bot;
    }


    
    public function flow_builder_upload_media()
    {
        if (! headers_sent()) {
            header('Content-Type: application/json');
        }

        $this->ajax_check();

        // Determines upload path
        $upload_dir = APPPATH . '../upload/flow_builder/';

        if (! file_exists($upload_dir)) {
            mkdir($upload_dir, 0755);
        }

        // Starts uploading file
        if (isset($_FILES['media_file'])) {
            $error = $_FILES['media_file']['error'];

            if($error) {
                $upload_errors = [
                    0 => 'There is no error, the file uploaded with success',
                    1 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
                    2 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
                    3 => 'The uploaded file was only partially uploaded',
                    4 => 'No file was uploaded',
                    6 => 'Missing a temporary folder',
                    7 => 'Failed to write file to disk.',
                    8 => 'A PHP extension stopped the file upload.',
                ];

                echo json_encode([
                    'status' => false,
                    'message' => $upload_errors[$error]
                ]);
                exit;
            }

            if (is_uploaded_file($_FILES['media_file']['tmp_name'])) {
                $tmp_name = $_FILES['media_file']['tmp_name'];
                $post_filename = $_FILES["media_file"]["name"];
                $mime_type = mime_content_type($tmp_name);

                if (! $mime_type) {
                    echo json_encode([
                        'status' => false,
                        'message' => $this->lang->line('File mime type is not allowed'),
                    ]);
                    exit();
                }

                $extension = mb_substr($post_filename, mb_strrpos($post_filename, '.'));

                /**
                 * An array of supported mime types
                 * @var $supported_mime_types
                 */
                $supported_mime_types = [
                    // Image extensions
                    '.jpeg',

                    '.jpg',

                    '.png',

                    '.gif',

                    // Video extensions
                    '.flv',

                    // ogv or ogg videos
                    '.ogg',

                    // '.webm',

                    // 3gp or mts videos 
                    // '.3gpp',

                    '.mp4',

                    // '.mkv',

                    // '.mpeg',

                    // '.mov',

                    // '.avi', 

                    '.wmv',

                    // '.m4v',

                    // Audio extensions
                    '.amr',

                    '.mp3',

                    '.wav',

                    // File extensions
                    '.doc', 
                    
                    '.docx', 
                    
                    '.pdf', 
                    
                    '.txt', 
                    
                    '.ppt',
                    
                    '.pptx', 
                    
                    '.xls', 
                    
                    '.xlsx',
                ];

                if(! in_array(strtolower($extension), $supported_mime_types)) {
                    echo json_encode([
                        'status' => false,
                        'message' => $this->lang->line('File type is not allowed'),
                    ]);
                    exit();
                }

                $filename = 'flow_builder_' . $this->user_id . '_' . time() . substr(uniqid(mt_rand(), true), 0, 6) . $extension;
                $destination = $upload_dir . $filename;

                if (move_uploaded_file($tmp_name, $destination)) {

                    // Changes the file permission
                    chmod($destination, 0644);

                    $file = base_url() . 'upload/flow_builder/' . $filename;

                    echo json_encode([
                        'status' => true,
                        'mime_type' => $mime_type,
                        'file' => $file,
                    ]);
                    exit;
                } else {
                    echo json_encode([
                        'status' => false,
                        'message' => $this->lang->line('Something went wrong while uploading file'),
                    ]);
                    exit();
                }
            }
        }

        echo json_encode([
            'status' => false,
            'message' => $this->lang->line('Something went wrong while uploading file'),
        ]);
        exit();
    }

    public function flow_builder_delete_media()
    {
        if (! headers_sent()) {
            header('Content-Type: application/json');
        }

        $this->ajax_check();

        $upload_dir = APPPATH . '../upload/flow_builder/';

        if(isset($_POST['file'])) {
            $file = filter_var($_POST['file'], FILTER_VALIDATE_URL, FILTER_FLAG_PATH_REQUIRED);

            $file_paths = explode('/', $file);
            $filename = end($file_paths);

            if (! $filename) {
                echo json_encode([
                    'status' => false,
                    'message' => $this->lang->line('Invalid file provided'),
                ]);
                exit();
            }

            $absolute_file_path = $upload_dir . $filename;

            if (! is_dir($absolute_file_path) && file_exists($absolute_file_path)) {
                
                // Deletes the file
                unlink($absolute_file_path);

                echo json_encode([
                    'status' => true,
                    'message' => $this->lang->line('File has been deleted successfully'),
                ]);
                exit;
            } else {
                echo json_encode([
                    'status' => false,
                    'message' => $this->lang->line('Could not delete the file'),
                ]);
                exit();
            }
        }

        echo json_encode([
            'status' => false,
            'message' => $this->lang->line('Bad request'),
        ]);
        exit;
    }


    public function load_builder($page_table_id = '', $go_back_link=1)
    {
        $info = $this->basic->get_data('facebook_rx_fb_page_info',['where'=>['id'=>$page_table_id,'user_id'=>$this->user_id]],['id']);
        if($page_table_id == '' || empty($info))
            redirect('visual_flow_builder/flowbuilder_manager', 'location');

        $user_input_flow_addon = 0;
        if($this->basic->is_exist("add_ons",array("project_id"=>49)))
            if($this->session->userdata('user_type') == 'Admin' || in_array(292,$this->module_access))
                $user_input_flow_addon = 1;
        $data['user_input_flow_addon'] = $user_input_flow_addon;

        $sequence_addon = 0;
        if($this->basic->is_exist("add_ons",array("project_id"=>30)))
            if($this->session->userdata('user_type') == 'Admin' || in_array(219,$this->module_access))
                $sequence_addon = 1;
        $data['sequence_addon'] = $sequence_addon;

        if($go_back_link == 1)
        	$data['go_back_link'] = base_url('visual_flow_builder/flowbuilder_manager');
        else
        	$data['go_back_link'] = base_url('messenger_bot/template_manager');

        $data['body'] = 'index';
        $data['page_title'] = $this->lang->line('Add new flow');
        $data['page_table_id'] = $page_table_id;
        $data['json_data'] = null;
        $data['builder_table_id'] = 0;

        $this->load->view('index.php', $data); 
    } 

    public function edit_builder_data($table_id = 0, $go_back_link=1)
    {
        $info = $this->basic->get_data('visual_flow_builder_campaign',['where'=>['user_id'=>$this->user_id,'id'=>$table_id]]);
        if(empty($info) || $table_id==0)
            redirect('visual_flow_builder/flowbuilder_manager', 'location');

        $user_input_flow_addon = 0;
        if($this->basic->is_exist("add_ons",array("project_id"=>49)))
            if($this->session->userdata('user_type') == 'Admin' || in_array(292,$this->module_access))
                $user_input_flow_addon = 1;
        $data['user_input_flow_addon'] = $user_input_flow_addon;

        $sequence_addon = 0;
        if($this->basic->is_exist("add_ons",array("project_id"=>30)))
            if($this->session->userdata('user_type') == 'Admin' || in_array(219,$this->module_access))
                $sequence_addon = 1;
        $data['sequence_addon'] = $sequence_addon;

        if($go_back_link == 1)
        	$data['go_back_link'] = base_url('visual_flow_builder/flowbuilder_manager');
        else if($go_back_link == 2)
        	$data['go_back_link'] = base_url('messenger_bot/template_manager');
        else
        	$data['go_back_link'] = base_url('messenger_bot/bot_list');

        $data['body'] = 'index';
        $data['page_title'] = $this->lang->line('Edit flow');
        $data['page_table_id'] = $info[0]['page_id'] ?? 0;
        $data['json_data'] = $info[0]['json_data'] ?? null;
        $data['builder_table_id'] = $table_id;
        $this->load->view('index.php', $data);
    } 


    public function flowbuilder_manager($page_id=0)
    {
        $data['body'] = 'flow_builder_list';
        $data['page_title'] = $this->lang->line('Visual Flow Builder');

        $join = array('facebook_rx_fb_user_info'=>'facebook_rx_fb_page_info.facebook_rx_fb_user_info_id=facebook_rx_fb_user_info.id,left');
        $page_info = $this->basic->get_data('facebook_rx_fb_page_info',array('where'=>array('facebook_rx_fb_page_info.user_id'=>$this->user_id,'bot_enabled'=>'1')),array('facebook_rx_fb_page_info.id','page_name','name'),$join);
        $page_list = array();
        foreach($page_info as $value)
        {
            $page_list[$value['id']] = $value['page_name']." [".$value['name']."]";
        }
        $data['page_list'] = $page_list;
        $data['page_auto_id'] = $page_id; 
        $this->_viewcontroller($data);  
    }

    public function visual_flow_builder_data($page_auto_id=0)
    {

        if ($_SERVER['REQUEST_METHOD'] === 'GET')
        redirect('home/access_forbidden', 'location');

        $this->ajax_check();

        $search_value = $_POST['search']['value'];
        if($search_value == '')
            if($page_auto_id != 0)
                $search_value = $page_auto_id;
        $display_columns = array("#",'id','reference_name','page_name');
        $search_columns = array('template_name');

        $page = isset($_POST['page']) ? intval($_POST['page']) : 1;
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $limit = isset($_POST['length']) ? intval($_POST['length']) : 10;
        $sort_index = isset($_POST['order'][0]['column']) ? strval($_POST['order'][0]['column']) : 1;
        $sort = isset($display_columns[$sort_index]) ? $display_columns[$sort_index] : 'visual_flow_builder_campaign.id';
        $order = isset($_POST['order'][0]['dir']) ? strval($_POST['order'][0]['dir']) : 'desc';
        $order_by=$sort." ".$order;

        $where_simple['visual_flow_builder_campaign.user_id'] = $this->user_id;
        $sql = '';
        if ($search_value != '') $sql = "(reference_name LIKE  '%".$search_value."%' OR visual_flow_builder_campaign.page_id = '".$search_value."' OR page_name LIKE  '%".$search_value."%')";
        if($sql != '') $this->db->where($sql);
        $where = array('where' => $where_simple);

        $table="visual_flow_builder_campaign";
        $join = array('facebook_rx_fb_page_info' => "visual_flow_builder_campaign.page_id = facebook_rx_fb_page_info.id,left");
        $select =array('visual_flow_builder_campaign.*','facebook_rx_fb_page_info.page_name');
        $info=$this->basic->get_data($table,$where,$select,$join,$limit,$start,$order_by,$group_by='');


        $total_rows_array=$this->basic->count_row($table,$where,$count=$table.".id",$join,$group_by='');
        $total_result=$total_rows_array[0]['total_rows'];

        $data['draw'] = (int)$_POST['draw'] + 1;
        $data['recordsTotal'] = $total_result;
        $data['recordsFiltered'] = $total_result;
        $data['data'] = convertDataTableResult($info, $display_columns ,$start,$primary_key="id");

        echo json_encode($data);
   
    }

    public function delete_flowbuilder_data()
    {
        $this->ajax_check();

        $table_id = $this->input->post('table_id',true);
        $response = [];
        $info = $this->basic->get_data('visual_flow_builder_campaign',['where'=>['id'=>$table_id,'user_id'=>$this->user_id]]);
        if(empty($info))
        {
            $response['status'] = 0; 
            $response['message'] = $this->lang->line('This campaign does not belong to you.');
        }
        else
        {
            $this->db->trans_start();

            $this->basic->delete_data('visual_flow_builder_campaign',['id'=>$table_id,'user_id'=>$this->user_id]);

            // $this->basic->delete_data('messenger_bot',['visual_flow_campaign_id'=>$table_id,'user_id'=>$this->user_id]);

            $this->basic->delete_data('messenger_bot',['visual_flow_campaign_id'=>$table_id,'user_id'=>$this->user_id,'keyword_type'=>'reply']);
            $this->basic->update_data('messenger_bot',['visual_flow_campaign_id'=>$table_id,'user_id'=>$this->user_id,'keyword_type !='=>'reply'],['visual_flow_campaign_id'=>0, 'visual_flow_type'=>'general']);

            // $this->basic->delete_data('messenger_bot_postback',['visual_flow_campaign_id'=>$table_id,'user_id'=>$this->user_id]);

            $this->basic->delete_data('messenger_bot_postback',['visual_flow_campaign_id'=>$table_id,'user_id'=>$this->user_id,'template_for'=>'reply_message']);
            $this->basic->update_data('messenger_bot_postback',['visual_flow_campaign_id'=>$table_id,'user_id'=>$this->user_id,'template_for !='=>'reply_message'], ['visual_flow_campaign_id'=>0, 'visual_flow_type'=>'general']);

            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE)
            {
                $response['status'] = 0; 
                $response['message'] = $this->lang->line('Deleting template was unsuccessful. Database error occured during deleting template.');
            }
            else
            {
                $response['status'] = 1; 
                $response['message'] = $this->lang->line('Template and all of the corresponding data have been deleted successfully.');
            }
        }
        echo json_encode($response,true);
    }

    public function get_broadcast_tags()
    {
        if (! headers_sent()) {
            header('Content-Type: application/json');
        }

        $old_tags = array
        (
            "ACCOUNT_UPDATE" => "ACCOUNT_UPDATE",
            "APPLICATION_UPDATE" => "APPLICATION_UPDATE",
            "APPOINTMENT_UPDATE" => "APPOINTMENT_UPDATE",
            "BUSINESS_PRODUCTIVITY" => "BUSINESS_PRODUCTIVITY",
            "COMMUNITY_ALERT" => "COMMUNITY_ALERT",
            "CONFIRMED_EVENT_REMINDER" => "CONFIRMED_EVENT_REMINDER",
            "FEATURE_FUNCTIONALITY_UPDATE" => "FEATURE_FUNCTIONALITY_UPDATE",
            "GAME_EVENT" => "GAME_EVENT",
            "ISSUE_RESOLUTION" => "ISSUE_RESOLUTION",
            "PAIRING_UPDATE" => "PAIRING_UPDATE",
            "PAYMENT_UPDATE" => "PAYMENT_UPDATE",
            "PERSONAL_FINANCE_UPDATE" => "PERSONAL_FINANCE_UPDATE",
            "RESERVATION_UPDATE" => "RESERVATION_UPDATE",
            "SHIPPING_UPDATE" => "SHIPPING_UPDATE",
            "TICKET_UPDATE" => "TICKET_UPDATE",
            "TRANSPORTATION_UPDATE" => "TRANSPORTATION_UPDATE",
        );

        $new_tags = array
        (
            "ACCOUNT_UPDATE"=>"ACCOUNT_UPDATE",
            "CONFIRMED_EVENT_UPDATE"=>"CONFIRMED_EVENT_UPDATE",
            "HUMAN_AGENT"=>"HUMAN_AGENT (Closed BETA)",
            "POST_PURCHASE_UPDATE"=>"POST_PURCHASE_UPDATE",        
            "NON_PROMOTIONAL_SUBSCRIPTION" => "NON_PROMOTIONAL_SUBSCRIPTION (NPI REGISTERED ONLY)"
        );

        echo json_encode($new_tags);
    }
}