<?php
/*
Addon Name: Ecommerce Enhancer
Unique Name: ecommerce_enhancer
Modules:
{
   "281":{
      "bulk_limit_enabled":"0",
      "limit_enabled":"0",
      "extra_text":"",
      "module_name":"Ecommerce Enhancer"
   }
}
Project ID: 109
Addon URI: https://xerochat.com
Author: Xerone IT
Author URI: https://xeroneit.net
Version: 1.2
Description: 
*/
// include("application/modules/ecommerce_enhancer/lvs_config.php");

require("application/controllers/Home.php"); // loading home controller


class Ecommerce_enhancer extends Home
{
    public $version = 1.2 ;

	public $addon_data=array();


    public function __construct($params=array())
    {

        parent::__construct();

        $addon_path=APPPATH."modules/".strtolower($this->router->fetch_class())."/controllers/".ucfirst($this->router->fetch_class()).".php"; // path of addon controller
        $this->addon_data=$this->get_addon_data($addon_path); 

        $this->member_validity();

        $this->user_id=$this->session->userdata('user_id'); // user_id of logged in user, we may need it
    if($this->session->userdata('user_type') == 'Admin'){
            $this->update_addon_data_to_db();    
        }

    }


    public function index()
  	{
  	    
      $this->activate();
  	}
  	
//make call to server


    public function activate()
    {
        //   $this->activate(); 

function is_valid_license($licensekey,$force_host_binding=true){
        $url="https://license.meertech.net/api/v1/validate/license?licensekey=".urlencode($licensekey)."&apikey=mYMaclLARLvK";
        if($force_host_binding){
            $url.="&host=".$_SERVER['HTTP_HOST'];
            $url.="&host_ip=".$_SERVER['SERVER_ADDR'];
        }
        $response=explore_url($url,false);
        if($response->code==600){
            return true;
        }
        return false;
    }
    function explore_url($url){
        // if($add_fix_params){$url.=$this->_FIX_PARAMS;}
        $ch=curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 20
        ));
        //response
        $response = curl_exec($ch);
        if (curl_errno($ch) > 0){
            $arrContextOptions=array("ssl"=>array("verify_peer"=>false,"verify_peer_name"=>false,),);  
            $response=file_get_contents($url,false,stream_context_create($arrContextOptions));
            if(empty($response)){
                if($stream=fopen($url, 'r')){
                    $response=stream_get_contents($stream);
                    fclose($stream);
                }else{
                    return null; 
                    // print curl_error($ch);                    
                }
            }
        }
        //result in object format
        $data = json_decode($response);
        curl_close($ch);
        return $data;
    }
    

        $this->ajax_check();
   


        

   
        $addon_controller_name=ucfirst($this->router->fetch_class()); // here addon_controller_name name is Comment [origianl file is Comment.php, put except .php]
        $purchase_code=$this->input->post('purchase_code');
if(is_valid_license($purchase_code)==true){

        // $this->addon_credential_check($purchase_code,strtolower($addon_controller_name)); // retuns json status,message if error
                
        //this addon system support 2-level sidebar entry, to make sidebar entry you must provide 2D array like below
        $sidebar=array();  

        // mysql raw query needed to run, it's an array, put each query in a seperate index, create table query must should IF NOT EXISTS
        $sql=array(
            1=> "
            CREATE TABLE IF NOT EXISTS `ecommerce_enhancer` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `product_id` int(11) NOT NULL,
              `attribute_id` int(11) NOT NULL,
              `attribute_option_name` varchar(255) NOT NULL,
              `price_indicator` varchar(5) NOT NULL,
              `amount` float NOT NULL,
              `stock` int(11) NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
        ); 

        //send blank array if you does not need sidebar entry,send a blank array if your addon does not need any sql to run
        $this->register_addon($addon_controller_name,$sidebar,$sql,$purchase_code); 
        
    }
    else{
        $this->addon_credential_check($purchase_code,strtolower($addon_controller_name));
    }

    }


    public function deactivate()
    {        
        $this->ajax_check();
   
        $addon_controller_name=ucfirst($this->router->fetch_class()); // here addon_controller_name name is Comment [origianl file is Comment.php, put except .php]
        // only deletes add_ons,modules and menu, menu_child1 table entires and put install.txt back, it does not delete any files or custom sql
        $this->unregister_addon($addon_controller_name);         
    }

    public function delete()
    {        
        $this->ajax_check();
 
        $addon_controller_name=ucfirst($this->router->fetch_class()); // here addon_controller_name name is Comment [origianl file is Comment.php, put except .php]

        // mysql raw query needed to run, it's an array, put each query in a seperate index, drop table/column query should have IF EXISTS
        $sql = array(1=>"DROP TABLE IF EXISTS `ecommerce_enhancer`;"); 
        
        // deletes add_ons,modules and menu, menu_child1 table ,custom sql as well as module folder, no need to send sql or send blank array if you does not need any sql to run on delete
        $this->delete_addon($addon_controller_name,$sql);         
    }
 
    public function update_addon_data_to_db(){
        
        $r = $this->db->query(" SELECT * FROM `add_ons` where unique_name = 'ecommerce_enhancer' ")->row_array();
        if(!$r){
            return;
        }else{
            if($r['version'] == $this->version){
                return;
            }
            
            $version = $this->version."";
            $TableData = array(
                'version' => $version,
                'update_at' => date("Y-m-d H:i:s"),
            );
            $Tablewhere = array('id'=>$r['id']);
            $this->basic->update_data('add_ons',$Tablewhere,$TableData);
        }
        
    }
    
    // public function init_db_template(){
    //     try{
    //         $sql = "CREATE TABLE IF NOT EXISTS `ecommerce_enhancer` (
    //           `id` int(11) NOT NULL AUTO_INCREMENT,
    //           `user_id` int(11) NOT NULL,
    //           `img_url` varchar(200) COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
    //           `name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
    //           `flow_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    //           `template_id` VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL,
    //           `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    //           PRIMARY KEY (`id`),
    //           KEY `user_id` (`user_id`)
    //         ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    //          $this->db->query($sql);
    //     }catch(Exception $e){
            
    //     }
        
    //     $template_table = $this->db->query(" SHOW TABLES LIKE 'ecommerce_enhancer'; ")->row_array();
    //     if($template_table){
    //         $tableHasValue = $this->db->query(" SELECT * FROM `ecommerce_enhancer` ")->row_array();
    //         if( count($tableHasValue) < 1 ){
    //             try{
    //                 $templates = $this->get_init_templates();
    //                 foreach($templates as $hash=>$data){
    //                     $profile = json_decode(base64_decode($hash),true);
    //                     $name = $profile['name'];
    //                     $img_url = $profile['img'];
    //                     $flow_data = $data;
    //                     $this->ext_create_new_template($this->user_id, $img_url, $name, $flow_data );
    //                 }
    //             }catch(Exception $e){
                    
    //             }                      
    //         }
    //     }
        
    //     $maintable = $this->db->query(" SHOW TABLES LIKE 'ext_flow_builder'; ")->row_array();
    //     if($maintable){
    //         $template_table = $this->db->query(" SHOW COLUMNS FROM `ext_flow_builder` LIKE 'template_id'; ")->row_array();
    //         if(empty($template_table)){
    //             $this->db->query(" ALTER TABLE `ext_flow_builder` ADD `template_id` VARCHAR(255) COLLATE utf8mb4_unicode_ci NULL AFTER `flow_data`; ");
    //         }             
    //     };
    // }
  


}
